/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mosnowgolems.procedures;

import java.util.Optional;
import net.mcreator.mosnowgolems.entity.JukeboxManEntity;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class JukeboxManRightClickedOnEntityProcedure {
    public static void execute(LevelAccessor world, Entity entity, Entity sourceentity) {
        if (entity == null || sourceentity == null) {
            return;
        }
        Entity local_target_entity = null;
        Object local_source_entity_var = null;
        if (!world.isClientSide() && entity instanceof JukeboxManEntity) {
            local_target_entity = sourceentity;
            local_target_entity = entity;
            if (!(sourceentity instanceof Player)) {
                return;
            }
            Player player = (Player)sourceentity;
            ItemStack item_in_hand = player.getMainHandItem();
            Level level = entity.level();
            Optional songHolder = JukeboxSong.fromStack((HolderLookup.Provider)level.registryAccess(), (ItemStack)item_in_hand);
            if (songHolder.isPresent()) {
                if (entity.getPersistentData().getString("music_disc_id").isEmpty()) {
                    JukeboxSong song = (JukeboxSong)((Holder)songHolder.get()).value();
                    String discID = BuiltInRegistries.ITEM.getKey((Object)item_in_hand.getItem()).toString();
                    entity.getPersistentData().putString("music_disc_id", discID);
                    long songEndTime = level.getGameTime() + (long)song.lengthInTicks();
                    entity.getPersistentData().putLong("songEndTime", songEndTime);
                    entity.getPersistentData().putInt("textDisplayTimer", 60);
                    SoundEvent songToPlay = (SoundEvent)song.soundEvent().value();
                    level.playSound(null, entity, songToPlay, SoundSource.RECORDS, 4.0f, 1.0f);
                    if (!player.getAbilities().instabuild) {
                        item_in_hand.shrink(1);
                    }
                }
            } else {
                String discID = entity.getPersistentData().getString("music_disc_id");
                if (!discID.isEmpty()) {
                    ItemStack discToEject = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)discID)));
                    ItemEntity itemEntity = new ItemEntity(level, entity.getX(), entity.getY(), entity.getZ(), discToEject);
                    itemEntity.setPickUpDelay(10);
                    level.addFreshEntity((Entity)itemEntity);
                    entity.getPersistentData().putString("music_disc_id", "");
                    entity.getPersistentData().putLong("songEndTime", 0L);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.getPlayers(p -> p.distanceToSqr(entity) < 4096.0).forEach(p -> p.connection.send((Packet)new ClientboundStopSoundPacket(null, SoundSource.RECORDS)));
                    }
                }
            }
        }
    }
}

