/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mosnowgolems.procedures;

import javax.annotation.Nullable;
import net.mcreator.mosnowgolems.entity.NoteblockManEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber
public class NoteblockManRightClickedOnEntityProcedure {
    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        NoteblockManRightClickedOnEntityProcedure.execute((Event)event, event.getTarget());
    }

    public static void execute(Entity entity) {
        NoteblockManRightClickedOnEntityProcedure.execute(null, entity);
    }

    private static void execute(@Nullable Event event, Entity entity) {
        if (entity == null) {
            return;
        }
        double current_note = 0.0;
        BlockState local_block_state_below = Blocks.AIR.defaultBlockState();
        Entity local_target_entity = null;
        local_target_entity = entity;
        if (local_target_entity == null || !(local_target_entity instanceof NoteblockManEntity) || local_target_entity.level().isClientSide()) {
            return;
        }
        String block_id_string = local_target_entity.getPersistentData().getString("block_below_id");
        if (block_id_string.isEmpty()) {
            return;
        }
        BlockState block_state_below = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)block_id_string))).defaultBlockState();
        int currentNote = local_target_entity.getPersistentData().getInt("note");
        NoteBlockInstrument instrument = block_state_below.instrument();
        double headX = local_target_entity.getX();
        double headY = local_target_entity.getY() + (double)local_target_entity.getEyeHeight();
        double headZ = local_target_entity.getZ();
        local_target_entity.level().playSound(null, headX, headY, headZ, (SoundEvent)instrument.getSoundEvent().value(), SoundSource.RECORDS, 3.0f, (float)Math.pow(2.0, (double)(currentNote - 12) / 12.0));
        Level level = local_target_entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double colorValue = (double)currentNote / 24.0;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.NOTE, headX, headY, headZ, 0, colorValue, 0.0, 0.0, 1.0);
        }
        int nextNote = (currentNote + 1) % 25;
        local_target_entity.getPersistentData().putInt("note", nextNote);
    }
}

