/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.endervillages.block.custom;

import com.mojang.serialization.MapCodec;
import net.baffledbanana87.endervillages.block.ModBlockTags;
import net.baffledbanana87.endervillages.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbilities;

public class DragonFruitBlock
extends CropBlock {
    public static final MapCodec<DragonFruitBlock> CODEC = DragonFruitBlock.simpleCodec(DragonFruitBlock::new);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0)};

    public MapCodec<DragonFruitBlock> codec() {
        return CODEC;
    }

    public DragonFruitBlock(BlockBehaviour.Properties p_51328_) {
        super(p_51328_);
    }

    protected boolean canSurvive(BlockState p_48986_, LevelReader p_48987_, BlockPos p_48988_) {
        return p_48987_.getBlockState(p_48988_.below()).is(ModBlockTags.ENDER_FOOD_PLANTABLE);
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)ModItems.DRAGON_FRUIT.get();
    }

    protected VoxelShape getShape(BlockState p_51330_, BlockGetter p_51331_, BlockPos p_51332_, CollisionContext p_51333_) {
        return SHAPE_BY_AGE[this.getAge(p_51330_)];
    }

    public InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (stack.canPerformAction(ItemAbilities.SHEARS_CARVE) && this.getAge(state) >= this.getMaxAge()) {
            level.playSound(null, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            ItemEntity dropEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)ModItems.DRAGON_FRUIT.get()));
            level.addFreshEntity((Entity)dropEntity);
            level.setBlock(pos, this.getStateForAge(0), 2);
            level.gameEvent((Entity)player, (Holder)GameEvent.SHEAR, pos);
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }
}

