/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.endervillages.item.custom;

import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;

public class PoisonousPotato
extends Item {
    public PoisonousPotato(Item.Properties p_40710_) {
        super(p_40710_);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entityLiving) {
        ItemStack itemstack = super.finishUsingItem(stack, level, entityLiving);
        if (!level.isClientSide) {
            for (int i = 0; i < 50; ++i) {
                SoundSource soundsource;
                SoundEvent soundevent;
                double d0 = entityLiving.getX() + (entityLiving.getRandom().nextDouble() - 0.5) * 16.0;
                double d1 = Mth.clamp((double)(entityLiving.getY() + (double)(entityLiving.getRandom().nextInt(16) - 8)), (double)level.getMinY(), (double)(level.getMinY() + ((ServerLevel)level).getLogicalHeight() - 1));
                double d2 = entityLiving.getZ() + (entityLiving.getRandom().nextDouble() - 0.5) * 16.0;
                if (entityLiving.isPassenger()) {
                    entityLiving.stopRiding();
                }
                Vec3 vec3 = entityLiving.position();
                EntityTeleportEvent.ItemConsumption event = EventHooks.onItemConsumptionTeleport((LivingEntity)entityLiving, (ItemStack)stack, (double)d0, (double)d1, (double)d2);
                if (event.isCanceled()) {
                    return itemstack;
                }
                if (!entityLiving.randomTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) continue;
                level.gameEvent((Holder)GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)entityLiving));
                if (entityLiving instanceof Fox) {
                    soundevent = SoundEvents.FOX_TELEPORT;
                    soundsource = SoundSource.NEUTRAL;
                } else {
                    soundevent = SoundEvents.CHORUS_FRUIT_TELEPORT;
                    soundsource = SoundSource.PLAYERS;
                }
                level.playSound((Entity)((Player)null), entityLiving.getX(), entityLiving.getY(), entityLiving.getZ(), soundevent, soundsource);
                entityLiving.resetFallDistance();
                break;
            }
            if (entityLiving instanceof Player) {
                Player player = (Player)entityLiving;
                player.resetCurrentImpulseContext();
            }
        }
        return itemstack;
    }
}

