/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.endervillages;

import com.mojang.logging.LogUtils;
import net.baffledbanana87.endervillages.Config;
import net.baffledbanana87.endervillages.ModEffects.ModEffects;
import net.baffledbanana87.endervillages.block.ModBlock;
import net.baffledbanana87.endervillages.enchantments.ModEnchantmentEffects;
import net.baffledbanana87.endervillages.entity.ModEntities;
import net.baffledbanana87.endervillages.entity.client.end_cat.EndCatRenderer;
import net.baffledbanana87.endervillages.entity.client.end_golem.EndGolemRenderer;
import net.baffledbanana87.endervillages.entity.client.end_villager.EnderVillagerRenderer;
import net.baffledbanana87.endervillages.item.ModCreatriveModeTabs;
import net.baffledbanana87.endervillages.item.ModItems;
import net.baffledbanana87.endervillages.item.custom.ElytraChestplateLayer;
import net.baffledbanana87.endervillages.potions.ModPotions;
import net.baffledbanana87.endervillages.villager.ModVillager;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="endervillages")
public class EnderVillages {
    public static final String MOD_ID = "endervillages";
    private static final Logger LOGGER = LogUtils.getLogger();

    public EnderVillages(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        ModBlock.register(modEventBus);
        ModItems.register(modEventBus);
        ModCreatriveModeTabs.register(modEventBus);
        ModEntities.register(modEventBus);
        ModVillager.register(modEventBus);
        ModEnchantmentEffects.register(modEventBus);
        ModEffects.register(modEventBus);
        ModPotions.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="endervillages", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlock.ENDER_CARROT.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlock.ENDER_POTATO.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlock.ENDER_WHEAT.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlock.DRAGON_PLANT.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlock.LILY_OF_THE_END.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlock.ENDER_BREWING_STAND.get()), (RenderType)RenderType.cutout());
            EntityRenderers.register((EntityType)((EntityType)ModEntities.ENDER_VILLAGER.get()), EnderVillagerRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)ModEntities.ENDER_CAT.get()), EndCatRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)ModEntities.ENDER_GOLEM.get()), EndGolemRenderer::new);
        }

        @SubscribeEvent
        public static void addLayers(EntityRenderersEvent.AddLayers event) {
            for (PlayerSkin.Model skin : event.getSkins()) {
                PlayerRenderer renderer = (PlayerRenderer)event.getPlayerSkin(skin);
                if (renderer == null) continue;
                renderer.addLayer((RenderLayer)new ElytraChestplateLayer((RenderLayerParent<PlayerRenderState, PlayerModel>)renderer));
            }
        }
    }
}

