/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.endervillages.ModEffects;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class PearlHealEffect
extends MobEffect {
    public PearlHealEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
        if (!entity.level().isClientSide && this.isWearingFullSet(entity)) {
            entity.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 130, 1, false, true, true));
            entity.addEffect(new MobEffectInstance(MobEffects.SPEED, 130, 0, false, true, true));
        }
    }

    private boolean isWearingFullSet(LivingEntity entity) {
        ItemStack head = entity.getItemBySlot(EquipmentSlot.HEAD);
        ItemStack chest = entity.getItemBySlot(EquipmentSlot.CHEST);
        ItemStack legs = entity.getItemBySlot(EquipmentSlot.LEGS);
        ItemStack feet = entity.getItemBySlot(EquipmentSlot.FEET);
        return this.hasSameItem(head, "endervillages:end_helmet") && this.hasSameItem(chest, "endervillages:end_chestplate") && this.hasSameItem(legs, "endervillages:end_leggings") && this.hasSameItem(feet, "endervillages:end_boots");
    }

    private boolean hasSameItem(ItemStack stack, String id) {
        if (stack.isEmpty()) {
            return false;
        }
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)stack.getItem());
        return key != null && key.toString().equals(id);
    }
}

