/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.endervillages.item.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.baffledbanana87.endervillages.item.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ElytraChestplateLayer
extends RenderLayer<PlayerRenderState, PlayerModel> {
    private static final ResourceLocation ELYTRA_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/equipment/wings/elytra.png");
    private final ElytraModel elytraModel = new ElytraModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.ELYTRA));

    public ElytraChestplateLayer(RenderLayerParent<PlayerRenderState, PlayerModel> parent) {
        super(parent);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, PlayerRenderState state, float limbSwing, float limbSwingAmount) {
        ItemStack chestItem = state.chestEquipment;
        if (chestItem.getItem() != ModItems.END_CHESTPLATE.get()) {
            return;
        }
        poseStack.pushPose();
        this.elytraModel.setupAnim((HumanoidRenderState)state);
        VertexConsumer vertex = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)buffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)ELYTRA_TEXTURE), (boolean)false);
        this.elytraModel.renderToBuffer(poseStack, vertex, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

