/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.endervillages.enchantments.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public record ObyBreakerAffect(LevelBasedValue duration) implements EnchantmentEntityEffect
{
    public static final MapCodec<ObyBreakerAffect> CODEC = RecordCodecBuilder.mapCodec(p_342125_ -> p_342125_.group((App)LevelBasedValue.CODEC.fieldOf("duration").forGetter(p_344657_ -> p_344657_.duration())).apply((Applicative)p_342125_, ObyBreakerAffect::new));

    public void apply(ServerLevel level, int enchantmentLevel, EnchantedItemInUse item, Entity entity, Vec3 origin) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        BlockPos pos = BlockPos.containing((double)origin.x, (double)origin.y, (double)origin.z);
        if (level.getBlockState(pos).is(Blocks.OBSIDIAN) || level.getBlockState(pos).is(Blocks.CRYING_OBSIDIAN)) {
            int amplifier;
            living.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, switch (enchantmentLevel) {
                case 1 -> {
                    amplifier = 0;
                    yield 45;
                }
                case 2 -> {
                    amplifier = 1;
                    yield 45;
                }
                case 3 -> {
                    amplifier = 3;
                    yield 45;
                }
                default -> {
                    amplifier = 0;
                    yield 45;
                }
            }, amplifier, true, false));
        }
    }

    public MapCodec<? extends EnchantmentEntityEffect> codec() {
        return CODEC;
    }
}

