/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.endervillages.entity.custom.end_villager;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.baffledbanana87.endervillages.entity.ModEntities;
import net.baffledbanana87.endervillages.entity.custom.end_villager.EndVillagerGoalPackages;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.GolemSensor;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;

public class EndVillager
extends Villager {
    public EndVillager(EntityType<? extends Villager> p_35381_, Level p_35382_) {
        super(p_35381_, p_35382_);
    }

    public void aiStep() {
        if (this.level().isClientSide) {
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getRandomX(0.5), this.getRandomY() - 0.25, this.getRandomZ(0.5), (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
            }
        }
        super.aiStep();
    }

    @Nullable
    public EndVillager getBreedOffspring(ServerLevel p_150012_, AgeableMob p_150013_) {
        EndVillager villager = new EndVillager((EntityType<? extends Villager>)((EntityType)ModEntities.ENDER_VILLAGER.get()), (Level)p_150012_);
        villager.finalizeSpawn((ServerLevelAccessor)p_150012_, p_150012_.getCurrentDifficultyAt(villager.blockPosition()), EntitySpawnReason.BREEDING, null);
        return villager;
    }

    protected Brain<?> makeBrain(Dynamic<?> p_35445_) {
        Brain brain = this.brainProvider().makeBrain(p_35445_);
        this.registerBrainGoals((Brain<Villager>)brain);
        return brain;
    }

    public void refreshBrain(ServerLevel p_35484_) {
        Brain brain = this.getBrain();
        brain.stopAll(p_35484_, (LivingEntity)this);
        this.brain = brain.copyWithoutBehaviors();
        this.registerBrainGoals((Brain<Villager>)this.getBrain());
    }

    private void registerBrainGoals(Brain<Villager> p_35425_) {
        VillagerProfession villagerprofession = this.getVillagerData().getProfession();
        if (this.isBaby()) {
            p_35425_.setSchedule(Schedule.VILLAGER_BABY);
            p_35425_.addActivity(Activity.PLAY, EndVillagerGoalPackages.getPlayPackage((float)0.5f));
        } else {
            p_35425_.setSchedule(Schedule.VILLAGER_DEFAULT);
            p_35425_.addActivityWithConditions(Activity.WORK, EndVillagerGoalPackages.getWorkPackage((VillagerProfession)villagerprofession, (float)0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.JOB_SITE, (Object)MemoryStatus.VALUE_PRESENT)));
        }
        p_35425_.addActivity(Activity.CORE, EndVillagerGoalPackages.getCorePackage(villagerprofession, 0.5f));
        p_35425_.addActivityWithConditions(Activity.MEET, EndVillagerGoalPackages.getMeetPackage((VillagerProfession)villagerprofession, (float)0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.MEETING_POINT, (Object)MemoryStatus.VALUE_PRESENT)));
        p_35425_.addActivity(Activity.REST, EndVillagerGoalPackages.getRestPackage((VillagerProfession)villagerprofession, (float)0.5f));
        p_35425_.addActivity(Activity.IDLE, EndVillagerGoalPackages.getIdlePackage(villagerprofession, 0.5f));
        p_35425_.addActivity(Activity.PANIC, EndVillagerGoalPackages.getPanicPackage((VillagerProfession)villagerprofession, (float)0.5f));
        p_35425_.addActivity(Activity.PRE_RAID, EndVillagerGoalPackages.getPreRaidPackage((VillagerProfession)villagerprofession, (float)0.5f));
        p_35425_.addActivity(Activity.RAID, EndVillagerGoalPackages.getRaidPackage((VillagerProfession)villagerprofession, (float)0.5f));
        p_35425_.addActivity(Activity.HIDE, EndVillagerGoalPackages.getHidePackage((VillagerProfession)villagerprofession, (float)0.5f));
        p_35425_.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        p_35425_.setDefaultActivity(Activity.IDLE);
        p_35425_.setActiveActivityIfPossible(Activity.IDLE);
        p_35425_.updateActivityFromSchedule(this.level().getDayTime(), this.level().getGameTime());
    }

    public void spawnGolemIfNeeded(ServerLevel pServerLevel, long pGameTime, int pMinVillagerAmount) {
        AABB aabb;
        List list;
        List list1;
        if (this.wantsToSpawnGolem(pGameTime) && (list1 = (list = pServerLevel.getEntitiesOfClass(Villager.class, aabb = this.getBoundingBox().inflate(10.0, 10.0, 10.0))).stream().filter(p_186293_ -> p_186293_.wantsToSpawnGolem(pGameTime)).limit(5L).collect(Collectors.toList())).size() >= pMinVillagerAmount && !SpawnUtil.trySpawnMob((EntityType)((EntityType)ModEntities.ENDER_GOLEM.get()), (EntitySpawnReason)EntitySpawnReason.MOB_SUMMONED, (ServerLevel)pServerLevel, (BlockPos)this.blockPosition(), (int)10, (int)8, (int)6, (SpawnUtil.Strategy)SpawnUtil.Strategy.LEGACY_IRON_GOLEM, (boolean)false).isEmpty()) {
            list.forEach(GolemSensor::golemDetected);
        }
    }
}

