/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.endervillages.enchantments.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;

public record PumpkinAffect(LevelBasedValue duration) implements EnchantmentEntityEffect
{
    public static final MapCodec<PumpkinAffect> CODEC = RecordCodecBuilder.mapCodec(p_342125_ -> p_342125_.group((App)LevelBasedValue.CODEC.fieldOf("duration").forGetter(p_344657_ -> p_344657_.duration)).apply((Applicative)p_342125_, PumpkinAffect::new));

    public void apply(ServerLevel pLevel, int pEnchantmentLevel, EnchantedItemInUse pItem, Entity pEntity, Vec3 pOrigin) {
        if (!(pEntity instanceof Player)) {
            return;
        }
        Player player = (Player)pEntity;
        double radius = 450.0;
        List endermen = pLevel.getEntitiesOfClass(EnderMan.class, player.getBoundingBox().inflate(radius));
        for (EnderMan enderman : endermen) {
            enderman.stopBeingAngry();
        }
    }

    public MapCodec<? extends EnchantmentEntityEffect> codec() {
        return CODEC;
    }
}

