/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.endervillages.entity.client.end_cat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.baffledbanana87.endervillages.entity.client.end_cat.EndCatCollarLayer;
import net.baffledbanana87.endervillages.entity.client.end_cat.EndCatEyes;
import net.baffledbanana87.endervillages.entity.client.end_cat.EndCatModel;
import net.baffledbanana87.endervillages.entity.custom.end_cat.EndCat;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EndCatRenderer
extends MobRenderer<EndCat, EndCatModel<EndCat>> {
    public EndCatRenderer(EntityRendererProvider.Context p_173943_) {
        super(p_173943_, new EndCatModel(p_173943_.bakeLayer(ModelLayers.CAT)), 0.4f);
        this.addLayer((RenderLayer)new EndCatEyes((RenderLayerParent<EndCat, EndCatModel<EndCat>>)this));
        this.addLayer(new EndCatCollarLayer((RenderLayerParent<EndCat, EndCatModel<EndCat>>)this, p_173943_.getModelSet()));
    }

    public ResourceLocation getTextureLocation(EndCat pEntity) {
        return pEntity.getTextureId();
    }

    protected void scale(EndCat pLivingEntity, PoseStack pPoseStack, float pPartialTickTime) {
        super.scale((LivingEntity)pLivingEntity, pPoseStack, pPartialTickTime);
        pPoseStack.scale(0.8f, 0.8f, 0.8f);
    }

    protected void setupRotations(EndCat pEntity, PoseStack pPoseStack, float pBob, float pYBodyRot, float pPartialTick, float pScale) {
        super.setupRotations((LivingEntity)pEntity, pPoseStack, pBob, pYBodyRot, pPartialTick, pScale);
        float f = pEntity.getLieDownAmount(pPartialTick);
        if (f > 0.0f) {
            pPoseStack.translate(0.4f * f, 0.15f * f, 0.1f * f);
            pPoseStack.mulPose(Axis.ZP.rotationDegrees(Mth.rotLerp((float)f, (float)0.0f, (float)90.0f)));
            BlockPos blockpos = pEntity.blockPosition();
            for (Player player : pEntity.level().getEntitiesOfClass(Player.class, new AABB(blockpos).inflate(2.0, 2.0, 2.0))) {
                if (!player.isSleeping()) continue;
                pPoseStack.translate(0.15f * f, 0.0f, 0.0f);
                break;
            }
        }
    }
}

