/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class MenuPath {
    private final List<String> titles;

    private MenuPath(List<String> titles) {
        this.titles = Collections.unmodifiableList(new ArrayList<String>(titles));
    }

    public static MenuPath of(List<String> titles) {
        Objects.requireNonNull(titles, "titles");
        return new MenuPath(titles);
    }

    public static MenuPath root() {
        return new MenuPath(List.of());
    }

    public MenuPath child(String title) {
        ArrayList<String> copy = new ArrayList<String>(this.titles);
        copy.add(Objects.requireNonNull(title));
        return new MenuPath(copy);
    }

    public List<String> titles() {
        return this.titles;
    }

    public String toString() {
        return String.join((CharSequence)"/", this.titles);
    }
}

