/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.api.events;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.z2six.ezactions.api.MenuPath;

public final class ApiEvents {
    private final List<Consumer<MenuChanged>> menuChanged = new ArrayList<Consumer<MenuChanged>>();
    private final List<Consumer<ImportEvent>> imported = new ArrayList<Consumer<ImportEvent>>();

    public void onMenuChanged(Consumer<MenuChanged> cb) {
        if (cb != null) {
            this.menuChanged.add(cb);
        }
    }

    public void onImported(Consumer<ImportEvent> cb) {
        if (cb != null) {
            this.imported.add(cb);
        }
    }

    public void _fireChanged(MenuPath p, String why) {
        if (this.menuChanged.isEmpty()) {
            return;
        }
        MenuChanged evt = new MenuChanged(p, why);
        for (Consumer<MenuChanged> cb : List.copyOf(this.menuChanged)) {
            try {
                cb.accept(evt);
            }
            catch (Throwable throwable) {}
        }
    }

    public void _fireImported(MenuPath p, String json, int n) {
        if (this.imported.isEmpty()) {
            return;
        }
        ImportEvent evt = new ImportEvent(p, json, n);
        for (Consumer<ImportEvent> cb : List.copyOf(this.imported)) {
            try {
                cb.accept(evt);
            }
            catch (Throwable throwable) {}
        }
    }

    public static final class MenuChanged {
        public final MenuPath path;
        public final String reason;

        public MenuChanged(MenuPath path, String reason) {
            this.path = path;
            this.reason = reason;
        }
    }

    public static final class ImportEvent {
        public final MenuPath target;
        public final String json;
        public final int count;

        public ImportEvent(MenuPath target, String json, int count) {
            this.target = target;
            this.json = json;
            this.count = count;
        }
    }
}

