/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.api.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.data.click.IClickAction;
import org.z2six.ezactions.data.json.ClickActionSerializer;
import org.z2six.ezactions.data.menu.MenuItem;

final class JsonCodec {
    private JsonCodec() {
    }

    static JsonObject toJson(MenuItem mi) {
        JsonObject o = new JsonObject();
        JsonCodec.put(o, "id", mi.id());
        JsonCodec.put(o, "title", mi.title());
        JsonCodec.put(o, "note", mi.note());
        o.add("icon", (JsonElement)JsonNull.INSTANCE);
        if (mi.isCategory()) {
            o.addProperty("type", "BUNDLE");
            List<MenuItem> kids = null;
            try {
                kids = mi.childrenMutable();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            JsonArray arr = new JsonArray();
            if (kids != null) {
                for (MenuItem k : kids) {
                    try {
                        arr.add((JsonElement)JsonCodec.toJson(k));
                    }
                    catch (Throwable throwable) {}
                }
            }
            o.add("children", (JsonElement)arr);
        } else {
            o.addProperty("type", "ACTION");
            JsonObject a = new JsonObject();
            a.addProperty("kind", "internal");
            try {
                IClickAction act = mi.action();
                JsonObject data = ClickActionSerializer.serialize(act);
                a.add("data", (JsonElement)(data != null ? data : new JsonObject()));
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] JsonCodec: action serialize failed: {}", (Object)"ezactions", (Object)t.toString());
                a.add("data", (JsonElement)new JsonObject());
            }
            o.add("action", (JsonElement)a);
        }
        return o;
    }

    static MenuItem fromJson(JsonObject o) {
        String id = JsonCodec.optString(o, "id", JsonCodec.freshId("api"));
        String title = JsonCodec.optString(o, "title", "");
        String note = JsonCodec.optString(o, "note", "");
        String type = JsonCodec.optString(o, "type", "ACTION");
        if ("BUNDLE".equals(type)) {
            ArrayList<MenuItem> children = new ArrayList<MenuItem>();
            JsonArray arr = o.has("children") && o.get("children").isJsonArray() ? o.getAsJsonArray("children") : new JsonArray();
            for (JsonElement el : arr) {
                if (!el.isJsonObject()) continue;
                try {
                    children.add(JsonCodec.fromJson(el.getAsJsonObject()));
                }
                catch (Throwable throwable) {}
            }
            return new MenuItem(id, title, note, null, null, children);
        }
        IClickAction act = null;
        try {
            JsonObject action = o.has("action") && o.get("action").isJsonObject() ? o.getAsJsonObject("action") : new JsonObject();
            JsonObject data = action.has("data") && action.get("data").isJsonObject() ? action.getAsJsonObject("data") : new JsonObject();
            act = ClickActionSerializer.deserialize(data);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] JsonCodec: action deserialize failed: {}", (Object)"ezactions", (Object)t.toString());
        }
        return new MenuItem(id, title, note, null, act, null);
    }

    static JsonArray toJsonArray(List<MenuItem> list) {
        JsonArray arr = new JsonArray();
        if (list != null) {
            for (MenuItem mi : list) {
                arr.add((JsonElement)JsonCodec.toJson(mi));
            }
        }
        return arr;
    }

    static List<MenuItem> fromJsonArray(JsonArray arr) {
        ArrayList<MenuItem> out = new ArrayList<MenuItem>();
        for (JsonElement el : arr) {
            if (!el.isJsonObject()) continue;
            out.add(JsonCodec.fromJson(el.getAsJsonObject()));
        }
        return out;
    }

    private static void put(JsonObject o, String k, String v) {
        if (v == null) {
            o.add(k, (JsonElement)JsonNull.INSTANCE);
        } else {
            o.addProperty(k, v);
        }
    }

    private static String optString(JsonObject o, String k, String def) {
        if (o == null || !o.has(k)) {
            return def;
        }
        JsonElement e = o.get(k);
        return e == null || e.isJsonNull() ? def : e.getAsString();
    }

    private static String freshId(String prefix) {
        long t = System.currentTimeMillis();
        return prefix + "_" + Long.toHexString(t) + "_" + Integer.toHexString((int)(Math.random() * 65535.0));
    }
}

