/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.api.internal;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.z2six.ezactions.data.menu.MenuItem;
import org.z2six.ezactions.gui.editor.menu.MenuNavUtil;

final class TreeOps {
    private TreeOps() {
    }

    static List<MenuItem> findChildrenListById(List<MenuItem> root, String targetId) {
        if (root == null || targetId == null) {
            return null;
        }
        for (MenuItem mi : root) {
            List<MenuItem> r;
            if (mi == null) continue;
            if (Objects.equals(mi.id(), targetId)) {
                try {
                    return mi.childrenMutable();
                }
                catch (Throwable ignored) {
                    return null;
                }
            }
            if (!mi.isCategory()) continue;
            List<MenuItem> sub = null;
            try {
                sub = mi.childrenMutable();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (sub == null || (r = TreeOps.findChildrenListById(sub, targetId)) == null) continue;
            return r;
        }
        return null;
    }

    static boolean removeByIdRecursive(List<MenuItem> list, String id) {
        if (list == null || id == null) {
            return false;
        }
        Iterator<MenuItem> it = list.iterator();
        while (it.hasNext()) {
            MenuItem mi = it.next();
            if (mi == null || !Objects.equals(mi.id(), id)) continue;
            it.remove();
            return true;
        }
        for (MenuItem mi : list) {
            if (mi == null || !mi.isCategory()) continue;
            List<MenuItem> sub = null;
            try {
                sub = mi.childrenMutable();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (sub == null || !TreeOps.removeByIdRecursive(sub, id)) continue;
            return true;
        }
        return false;
    }

    static MenuItem findFirstById(List<MenuItem> list, String id) {
        if (list == null || id == null) {
            return null;
        }
        for (MenuItem mi : list) {
            MenuItem r;
            if (mi == null) continue;
            if (Objects.equals(mi.id(), id)) {
                return mi;
            }
            if (!mi.isCategory()) continue;
            List<MenuItem> sub = null;
            try {
                sub = mi.childrenMutable();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if ((r = TreeOps.findFirstById(sub, id)) == null) continue;
            return r;
        }
        return null;
    }

    static List<MenuItem> findBundleByTitles(List<MenuItem> root, List<String> titles) {
        if (root == null) {
            return null;
        }
        List<MenuItem> cur = root;
        if (titles == null || titles.isEmpty()) {
            return cur;
        }
        for (String title : titles) {
            boolean found = false;
            if (cur == null) {
                return null;
            }
            for (MenuItem mi : cur) {
                String t;
                if (mi == null || !mi.isCategory() || !(t = TreeOps.safe(mi.title())).equals(title)) continue;
                try {
                    cur = mi.childrenMutable();
                }
                catch (Throwable ignore) {
                    cur = null;
                }
                found = true;
                break;
            }
            if (found) continue;
            return null;
        }
        return cur;
    }

    static boolean existsPath(List<MenuItem> root, List<String> titles) {
        return TreeOps.findBundleByTitles(root, titles) != null;
    }

    static List<MenuItem> childrenOf(MenuItem bundle) {
        if (bundle == null || !bundle.isCategory()) {
            return null;
        }
        try {
            return bundle.childrenMutable();
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    static List<String> currentPathTitles() {
        try {
            return MenuNavUtil.capturePathTitles();
        }
        catch (Throwable ignored) {
            return List.of();
        }
    }

    private static String safe(String s) {
        return s == null ? "" : s;
    }
}

