/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.config;

import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.fml.loading.FMLPaths;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.config.DesignClientConfig;
import org.z2six.ezactions.config.GeneralClientConfig;
import org.z2six.ezactions.config.RadialAnimConfig;

public final class ConfigIO {
    private static final String DIR = "ezactions";
    private static final String FILE_GENERAL = "general-client.toml";
    private static final String FILE_ANIM = "anim-client.toml";
    private static final String FILE_DESIGN = "design-client.toml";

    private ConfigIO() {
    }

    public static void saveNow(Section section) {
        try {
            switch (section) {
                case GENERAL: {
                    ConfigIO.saveGeneralClient();
                    break;
                }
                case ANIM: {
                    ConfigIO.saveAnimClient();
                    break;
                }
                case DESIGN: {
                    ConfigIO.saveDesignClient();
                    break;
                }
                case ALL: {
                    ConfigIO.saveGeneralClient();
                    ConfigIO.saveAnimClient();
                    ConfigIO.saveDesignClient();
                }
            }
        }
        catch (Throwable t) {
            try {
                Constants.LOG.warn("[{}] ConfigIO.saveNow({}) failed: {}", new Object[]{DIR, section, t.toString()});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void saveGeneralClient() {
        Path f = ConfigIO.configDir().resolve(FILE_GENERAL);
        try {
            Files.createDirectories(f.getParent(), new FileAttribute[0]);
            try (CommentedFileConfig cfg2 = (CommentedFileConfig)CommentedFileConfig.builder((Path)f, (ConfigFormat)TomlFormat.instance()).sync().preserveInsertionOrder().build();){
                ConfigIO.safeLoad(cfg2);
                cfg2.set("general.moveWhileRadialOpen", GeneralClientConfig.INSTANCE.moveWhileRadialOpen.get());
                cfg2.set("general.commandEditorVisibleLines", GeneralClientConfig.INSTANCE.commandEditorVisibleLines.get());
                cfg2.save();
            }
            try {
                Constants.LOG.debug("[{}] Forced save OK: {}", (Object)DIR, (Object)f);
            }
            catch (Throwable cfg2) {}
        }
        catch (Throwable t) {
            try {
                Constants.LOG.warn("[{}] Failed to force-save {}: {}", new Object[]{DIR, f, t.toString()});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void saveAnimClient() {
        Path f = ConfigIO.configDir().resolve(FILE_ANIM);
        try {
            Files.createDirectories(f.getParent(), new FileAttribute[0]);
            try (CommentedFileConfig cfg2 = (CommentedFileConfig)CommentedFileConfig.builder((Path)f, (ConfigFormat)TomlFormat.instance()).sync().preserveInsertionOrder().build();){
                ConfigIO.safeLoad(cfg2);
                cfg2.set("animations.animationsEnabled", RadialAnimConfig.CONFIG.animationsEnabled.get());
                cfg2.set("animations.animOpenClose", RadialAnimConfig.CONFIG.animOpenClose.get());
                cfg2.set("animations.animHover", RadialAnimConfig.CONFIG.animHover.get());
                cfg2.set("animations.hoverGrowPct", RadialAnimConfig.CONFIG.hoverGrowPct.get());
                cfg2.set("animations.openCloseMs", RadialAnimConfig.CONFIG.openCloseMs.get());
                cfg2.save();
            }
            try {
                Constants.LOG.debug("[{}] Forced save OK: {}", (Object)DIR, (Object)f);
            }
            catch (Throwable cfg2) {}
        }
        catch (Throwable t) {
            try {
                Constants.LOG.warn("[{}] Failed to force-save {}: {}", new Object[]{DIR, f, t.toString()});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void saveDesignClient() {
        Path f = ConfigIO.configDir().resolve(FILE_DESIGN);
        try {
            Files.createDirectories(f.getParent(), new FileAttribute[0]);
            try (CommentedFileConfig cfg2 = (CommentedFileConfig)CommentedFileConfig.builder((Path)f, (ConfigFormat)TomlFormat.instance()).sync().preserveInsertionOrder().build();){
                ConfigIO.safeLoad(cfg2);
                cfg2.set("deadzone", DesignClientConfig.deadzone.get());
                cfg2.set("baseOuterRadius", DesignClientConfig.baseOuterRadius.get());
                cfg2.set("ringThickness", DesignClientConfig.ringThickness.get());
                cfg2.set("scaleStartThreshold", DesignClientConfig.scaleStartThreshold.get());
                cfg2.set("scalePerItem", DesignClientConfig.scalePerItem.get());
                cfg2.set("ringColor", DesignClientConfig.ringColor.get());
                cfg2.set("hoverColor", DesignClientConfig.hoverColor.get());
                cfg2.save();
            }
            try {
                Constants.LOG.debug("[{}] Forced save OK: {}", (Object)DIR, (Object)f);
            }
            catch (Throwable cfg2) {}
        }
        catch (Throwable t) {
            try {
                Constants.LOG.warn("[{}] Failed to force-save {}: {}", new Object[]{DIR, f, t.toString()});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static Path configDir() {
        try {
            return FMLPaths.CONFIGDIR.get().resolve(DIR);
        }
        catch (Throwable t) {
            try {
                Constants.LOG.warn("[{}] FMLPaths.CONFIGDIR unavailable, using relative ./config/{}", (Object)DIR, (Object)DIR);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return Path.of("config", DIR);
        }
    }

    private static void safeLoad(CommentedFileConfig cfg) {
        try {
            Path p = cfg.getFile().toPath();
            if (Files.exists(p, new LinkOption[0])) {
                cfg.load();
            }
        }
        catch (Throwable t) {
            try {
                Constants.LOG.debug("[{}] ConfigIO.safeLoad failed: {}", (Object)DIR, (Object)t.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static enum Section {
        GENERAL,
        ANIM,
        DESIGN,
        ALL;

    }
}

