/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.z2six.ezactions.Constants;

public final class GeneralClientConfig {
    public static final GeneralClientConfig INSTANCE;
    public static final ForgeConfigSpec SPEC;
    public final ForgeConfigSpec.BooleanValue moveWhileRadialOpen;
    public final ForgeConfigSpec.IntValue commandEditorVisibleLines;

    private GeneralClientConfig(ForgeConfigSpec.Builder b) {
        b.push("general");
        this.moveWhileRadialOpen = b.comment("If true, allow basic movement inputs while the EZActions radial is open.").define("moveWhileRadialOpen", false);
        this.commandEditorVisibleLines = b.comment("How many lines are shown in the command editor text box (visual only).").defineInRange("commandEditorVisibleLines", 6, 1, 32);
        b.pop();
    }

    public static boolean isMoveWhileRadialOpen() {
        try {
            return (Boolean)GeneralClientConfig.INSTANCE.moveWhileRadialOpen.get();
        }
        catch (Throwable t) {
            try {
                Constants.LOG.debug("[{}] Read moveWhileRadialOpen failed: {}", (Object)"ezactions", (Object)t.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
    }

    public static int getCommandEditorVisibleLines() {
        try {
            int v = (Integer)GeneralClientConfig.INSTANCE.commandEditorVisibleLines.get();
            if (v < 1) {
                return 1;
            }
            if (v > 32) {
                return 32;
            }
            return v;
        }
        catch (Throwable t) {
            try {
                Constants.LOG.debug("[{}] Read commandEditorVisibleLines failed: {}", (Object)"ezactions", (Object)t.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return 6;
        }
    }

    static {
        ForgeConfigSpec specTmp;
        GeneralClientConfig instanceTmp;
        try {
            Pair pair = new ForgeConfigSpec.Builder().configure(GeneralClientConfig::new);
            instanceTmp = (GeneralClientConfig)pair.getLeft();
            specTmp = (ForgeConfigSpec)pair.getRight();
            try {
                Constants.LOG.debug("[{}] GeneralClientConfig initialized successfully (ForgeConfigSpec).", (Object)"ezactions");
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable t) {
            instanceTmp = new GeneralClientConfig(new ForgeConfigSpec.Builder());
            specTmp = new ForgeConfigSpec.Builder().build();
            try {
                Constants.LOG.warn("[{}] GeneralClientConfig static init failed: {}. Using fallback defaults.", (Object)"ezactions", (Object)t.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        INSTANCE = instanceTmp;
        SPEC = specTmp;
    }
}

