/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.data.click;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.data.click.ClickActionType;
import org.z2six.ezactions.data.click.IClickAction;
import org.z2six.ezactions.util.CommandSequencer;

public final class ClickActionCommand
implements IClickAction {
    private final String commandRaw;
    private final int delayTicks;

    public ClickActionCommand(String command) {
        this(command, 0);
    }

    public ClickActionCommand(String command, int delayTicks) {
        this.commandRaw = command == null ? "" : command.trim();
        this.delayTicks = Math.max(0, delayTicks);
    }

    public String getCommand() {
        return this.commandRaw;
    }

    public String command() {
        return this.commandRaw;
    }

    public int getDelayTicks() {
        return this.delayTicks;
    }

    @Override
    public String getId() {
        String base = this.commandRaw.isEmpty() ? "<empty>" : this.commandRaw;
        return "cmd:" + base;
    }

    @Override
    public ClickActionType getType() {
        return ClickActionType.COMMAND;
    }

    @Override
    public Component getDisplayName() {
        String s = this.normalizedFirstLine();
        return Component.m_237113_((String)(s.isEmpty() ? "(empty)" : s));
    }

    @Override
    public boolean execute(Minecraft mc) {
        try {
            if (mc == null) {
                Constants.LOG.warn("[{}] Command execute: no Minecraft instance.", (Object)"ezactions");
                return false;
            }
            LocalPlayer player = mc.f_91074_;
            if (player == null || player.f_108617_ == null) {
                Constants.LOG.warn("[{}] Command execute: no player or connection.", (Object)"ezactions");
                return false;
            }
            String[] lines = ClickActionCommand.splitLinesNormalized(this.commandRaw);
            if (lines.length == 0) {
                Constants.LOG.warn("[{}] Command execute: empty command.", (Object)"ezactions");
                return false;
            }
            int dly = this.delayTicks;
            if (dly <= 0 || lines.length == 1) {
                mc.execute(() -> {
                    for (String cmd : lines) {
                        try {
                            player.f_108617_.m_246623_(cmd);
                            Constants.LOG.debug("[{}] Sent command: {}", (Object)"ezactions", (Object)cmd);
                        }
                        catch (Throwable t) {
                            Constants.LOG.warn("[{}] sendCommand failed for '{}': {}", new Object[]{"ezactions", cmd, t.toString()});
                        }
                    }
                });
            } else {
                CommandSequencer.enqueue(lines, dly);
                Constants.LOG.debug("[{}] Enqueued {} commands with {} tick(s) delay.", new Object[]{"ezactions", lines.length, dly});
            }
            return true;
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Command execute error for '{}': {}", new Object[]{"ezactions", this.commandRaw, t.toString()});
            return false;
        }
    }

    @Override
    public JsonObject serialize() {
        JsonObject o = new JsonObject();
        try {
            o.addProperty("type", this.getType().name());
            o.addProperty("command", this.commandRaw);
            o.addProperty("delayTicks", (Number)this.delayTicks);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] ClickActionCommand serialize failed: {}", (Object)"ezactions", (Object)t.toString());
        }
        return o;
    }

    public static ClickActionCommand deserialize(JsonObject o) {
        try {
            String cmd = o.has("command") ? o.get("command").getAsString() : "";
            int dly = o.has("delayTicks") ? Math.max(0, o.get("delayTicks").getAsInt()) : 0;
            return new ClickActionCommand(cmd, dly);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] ClickActionCommand deserialize failed: {}", (Object)"ezactions", (Object)t.toString());
            return new ClickActionCommand("");
        }
    }

    private static String[] splitLinesNormalized(String raw) {
        if (raw == null) {
            return new String[0];
        }
        String[] in = raw.replace("\r", "").split("\n");
        ArrayList<String> out = new ArrayList<String>(in.length);
        for (String line : in) {
            String s;
            String string = s = line == null ? "" : line.trim();
            if (s.isEmpty()) continue;
            if (s.startsWith("/")) {
                s = s.substring(1);
            }
            out.add(s);
        }
        return out.toArray(new String[0]);
    }

    private String normalizedFirstLine() {
        String raw = this.commandRaw == null ? "" : this.commandRaw.replace("\r", "");
        int nl = raw.indexOf(10);
        String first = nl >= 0 ? raw.substring(0, nl) : raw;
        if ((first = first.trim()).startsWith("/")) {
            first = first.substring(1);
        }
        return first;
    }
}

