/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.data.json;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.util.GsonHelper;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.data.click.ClickActionCommand;
import org.z2six.ezactions.data.click.ClickActionKey;
import org.z2six.ezactions.data.click.ClickActionType;
import org.z2six.ezactions.data.click.IClickAction;

public final class ClickActionSerializer {
    private ClickActionSerializer() {
    }

    public static JsonObject serialize(IClickAction action) {
        try {
            return action.serialize();
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] ClickActionSerializer.serialize failed for {}: {}", new Object[]{"ezactions", action.getId(), t.toString()});
            JsonObject o = new JsonObject();
            o.addProperty("type", action.getType().name());
            o.addProperty("error", t.toString());
            return o;
        }
    }

    public static IClickAction deserialize(JsonObject obj) {
        ClickActionType type;
        String typeStr = GsonHelper.m_13851_((JsonObject)obj, (String)"type", (String)"");
        try {
            type = ClickActionType.valueOf(typeStr);
        }
        catch (IllegalArgumentException e) {
            throw new JsonParseException("Unknown action type: " + typeStr);
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ClickActionType.KEY -> ClickActionKey.deserialize(obj);
            case ClickActionType.COMMAND -> ClickActionCommand.deserialize(obj);
        };
    }
}

