/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui.anim;

public final class AnimLerp {
    private AnimLerp() {
    }

    public static double clamp01(double v) {
        if (v < 0.0) {
            return 0.0;
        }
        if (v > 1.0) {
            return 1.0;
        }
        return v;
    }

    public static double lerp(double a, double b, double t) {
        return a + (b - a) * t;
    }

    public static double progress(long nowMs, long startMs, int durationMs) {
        if (durationMs <= 0) {
            return 1.0;
        }
        double t = (double)(nowMs - startMs) / (double)durationMs;
        return AnimLerp.clamp01(t);
    }

    public static double easeOutCubic(double t) {
        t = AnimLerp.clamp01(t);
        double inv = t - 1.0;
        return 1.0 + inv * inv * inv;
    }

    public static double easeInCubic(double t) {
        t = AnimLerp.clamp01(t);
        return t * t * t;
    }

    public static double easeInOutQuad(double t) {
        if ((t = AnimLerp.clamp01(t)) < 0.5) {
            return 2.0 * t * t;
        }
        return -1.0 + (4.0 - 2.0 * t) * t;
    }
}

