/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui.anim;

import org.z2six.ezactions.config.RadialAnimConfigView;
import org.z2six.ezactions.gui.anim.AnimLerp;

public final class RadialTransition {
    private Phase phase = Phase.NONE;
    private long start = 0L;
    private int durationMs = 0;

    public Phase phase() {
        return this.phase;
    }

    public boolean isActive() {
        return this.phase != Phase.NONE;
    }

    public void startOpening(long nowMs, int durMs) {
        this.phase = Phase.OPENING;
        this.start = nowMs;
        this.durationMs = Math.max(0, durMs);
    }

    public void startClosing(long nowMs, int durMs) {
        this.phase = Phase.CLOSING;
        this.start = nowMs;
        this.durationMs = Math.max(0, durMs);
    }

    public void startCatWipeOut(long nowMs, int durMs) {
        this.phase = Phase.CAT_WIPE_OUT;
        this.start = nowMs;
        this.durationMs = Math.max(0, durMs);
    }

    public void startCatWipeIn(long nowMs, int durMs) {
        this.phase = Phase.CAT_WIPE_IN;
        this.start = nowMs;
        this.durationMs = Math.max(0, durMs);
    }

    public double phaseProgress(long nowMs) {
        if (this.phase == Phase.NONE) {
            return 1.0;
        }
        return AnimLerp.clamp01(AnimLerp.progress(nowMs, this.start, this.durationMs));
    }

    public boolean isDone(long nowMs) {
        return this.phaseProgress(nowMs) >= 1.0;
    }

    public void start(int dir) {
        long now = System.currentTimeMillis();
        int ms = Math.max(1, RadialAnimConfigView.get().openCloseMs);
        if (dir >= 0) {
            this.startOpening(now, ms);
        } else {
            this.startClosing(now, ms);
        }
    }

    public void start(int dir, long nowMs) {
        int ms = Math.max(1, RadialAnimConfigView.get().openCloseMs);
        if (dir >= 0) {
            this.startOpening(nowMs, ms);
        } else {
            this.startClosing(nowMs, ms);
        }
    }

    public void startNow(int dir) {
        this.start(dir);
    }

    public float progress() {
        return (float)this.phaseProgress(System.currentTimeMillis());
    }

    public float progress(long nowMs) {
        return (float)this.phaseProgress(nowMs);
    }

    public void clear() {
        this.phase = Phase.NONE;
        this.start = 0L;
        this.durationMs = 0;
    }

    public static enum Phase {
        NONE,
        OPENING,
        CLOSING,
        CAT_WIPE_OUT,
        CAT_WIPE_IN;

    }
}

