/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui.editor;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.data.icon.IconSpec;
import org.z2six.ezactions.data.menu.MenuItem;
import org.z2six.ezactions.data.menu.RadialMenu;
import org.z2six.ezactions.gui.IconRenderer;
import org.z2six.ezactions.gui.editor.IconPickerScreen;
import org.z2six.ezactions.gui.editor.MenuEditorScreen;

public final class CategoryEditScreen
extends Screen {
    private static final int LABEL_TO_FIELD = 10;
    private static final int FIELD_TO_NEXT_LABEL = 5;
    private static final int FIRST_BUTTON_ROW_OFFSET = 10;
    private static final int BETWEEN_BUTTON_ROWS = 5;
    private final Screen parent;
    private final MenuItem editing;
    private String draftTitle = "";
    private String draftNote = "";
    private IconSpec draftIcon = IconSpec.item("minecraft:stone");
    private boolean draftHideFromMainRadial = false;
    private boolean draftEnableKeybind = false;
    private EditBox titleBox;
    private EditBox noteBox;
    private Checkbox hideFromMainCheckbox;
    private Checkbox enableKeybindCheckbox;
    private boolean showRestartHint = false;

    public CategoryEditScreen(Screen parent, MenuItem editing) {
        super((Component)Component.m_237113_((String)(editing == null ? "Add Bundle" : "Edit Bundle")));
        this.parent = parent;
        this.editing = editing;
        if (editing != null) {
            this.draftTitle = CategoryEditScreen.safe(editing.title());
            try {
                this.draftNote = CategoryEditScreen.safe(editing.note());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (editing.icon() != null) {
                this.draftIcon = editing.icon();
            }
            try {
                this.draftHideFromMainRadial = editing.hideFromMainRadial();
                this.draftEnableKeybind = editing.bundleKeybindEnabled();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static String safe(String s) {
        return s == null ? "" : s;
    }

    protected void m_7856_() {
        int cx = this.f_96543_ / 2;
        int y = 48;
        this.titleBox = new EditBox(this.f_96547_, cx - 140, y, 280, 20, (Component)Component.m_237113_((String)"Title"));
        this.titleBox.m_257771_((Component)Component.m_237113_((String)"Bundle title (e.g., Utilities)"));
        this.titleBox.m_94144_(this.draftTitle);
        this.titleBox.m_94151_(s -> {
            this.draftTitle = CategoryEditScreen.safe(s);
        });
        this.m_142416_((GuiEventListener)this.titleBox);
        this.noteBox = new EditBox(this.f_96547_, cx - 140, y += 35, 280, 20, (Component)Component.m_237113_((String)"Note"));
        this.noteBox.m_257771_((Component)Component.m_237113_((String)"Optional note (shown as tooltip in editor)"));
        this.noteBox.m_94144_(this.draftNote);
        this.noteBox.m_94151_(s -> {
            this.draftNote = CategoryEditScreen.safe(s);
        });
        this.m_142416_((GuiEventListener)this.noteBox);
        y += 20;
        this.hideFromMainCheckbox = new Checkbox(cx - 140, y += 6, 280, 20, (Component)Component.m_237113_((String)"Hide from main radial"), this.draftHideFromMainRadial){

            public void m_5691_() {
                super.m_5691_();
                try {
                    CategoryEditScreen.this.draftHideFromMainRadial = this.m_93840_();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        try {
            this.draftHideFromMainRadial = this.hideFromMainCheckbox.m_93840_();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_142416_((GuiEventListener)this.hideFromMainCheckbox);
        this.enableKeybindCheckbox = new Checkbox(cx - 140, y += 24, 280, 20, (Component)Component.m_237113_((String)"Enable keybind"), this.draftEnableKeybind){

            public void m_5691_() {
                super.m_5691_();
                try {
                    CategoryEditScreen.this.draftEnableKeybind = this.m_93840_();
                    CategoryEditScreen.this.showRestartHint = true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        try {
            this.draftEnableKeybind = this.enableKeybindCheckbox.m_93840_();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_142416_((GuiEventListener)this.enableKeybindCheckbox);
        y += 20;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Choose Icon"), b -> this.f_96541_.m_91152_((Screen)new IconPickerScreen(this, ic -> {
            this.draftIcon = ic == null ? IconSpec.item("minecraft:stone") : ic;
            this.f_96541_.m_91152_((Screen)this);
        }))).m_252987_(cx - 140, y += 10, 280, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> this.onSavePressed()).m_252987_(cx - 140, y += 25, 90, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> this.m_7379_()).m_252987_(cx - 44, y, 90, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), b -> this.f_96541_.m_91152_(this.parent)).m_252987_(cx + 52, y, 90, 20).m_253136_());
    }

    private void onSavePressed() {
        try {
            Screen screen;
            boolean ok;
            this.draftTitle = CategoryEditScreen.safe(this.titleBox == null ? this.draftTitle : this.titleBox.m_94155_()).trim();
            this.draftNote = CategoryEditScreen.safe(this.noteBox == null ? this.draftNote : this.noteBox.m_94155_()).trim();
            try {
                if (this.hideFromMainCheckbox != null) {
                    this.draftHideFromMainRadial = this.hideFromMainCheckbox.m_93840_();
                }
                if (this.enableKeybindCheckbox != null) {
                    this.draftEnableKeybind = this.enableKeybindCheckbox.m_93840_();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.draftTitle.isEmpty()) {
                Constants.LOG.warn("[{}] CategoryEdit: Title empty; ignoring save.", (Object)"ezactions");
                return;
            }
            String newId = this.draftTitle;
            if (RadialMenu.isBundleNameTaken(newId, this.editing)) {
                Constants.LOG.warn("[{}] CategoryEdit: Duplicate bundle title/id '{}' detected; save aborted.", (Object)"ezactions", (Object)newId);
                try {
                    if (this.titleBox != null) {
                        this.titleBox.m_94202_(-43691);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            ArrayList<MenuItem> children = new ArrayList<MenuItem>();
            if (this.editing != null) {
                try {
                    children.addAll(this.editing.childrenMutable());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            boolean hideFlag = this.draftHideFromMainRadial;
            boolean keybindFlag = this.draftEnableKeybind;
            MenuItem newItem = new MenuItem(newId, this.draftTitle, this.draftNote, this.draftIcon, null, children, hideFlag, keybindFlag);
            boolean bl = ok = this.editing == null ? RadialMenu.addToCurrent(newItem) : RadialMenu.replaceInCurrent(this.editing.id(), newItem);
            if (!ok) {
                Constants.LOG.info("[{}] Category save failed (page full or replace failed) '{}'.", (Object)"ezactions", (Object)this.draftTitle);
            }
            if ((screen = this.parent) instanceof MenuEditorScreen) {
                MenuEditorScreen m = (MenuEditorScreen)screen;
                m.refreshFromChild();
            }
            this.f_96541_.m_91152_(this.parent);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] CategoryEdit onSave failed: {}", (Object)"ezactions", (Object)t.toString());
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        g.m_280509_(0, 0, this.f_96543_, this.f_96544_, -2013265920);
        g.m_280509_(12, 52, this.f_96543_ - 12, this.f_96544_ - 36, -1072689136);
        g.m_280137_(this.f_96547_, this.f_96539_.getString(), this.f_96543_ / 2, 14, 0xFFFFFF);
        if (this.titleBox != null) {
            g.m_280488_(this.f_96547_, "Title:", this.titleBox.m_252754_(), this.titleBox.m_252907_() - 10, 0xA0A0A0);
        }
        if (this.noteBox != null) {
            g.m_280488_(this.f_96547_, "Note:", this.noteBox.m_252754_(), this.noteBox.m_252907_() - 10, 0xA0A0A0);
        }
        int boxW = 60;
        int boxH = 60;
        int bx = this.f_96543_ - boxW - 16;
        int by = 16;
        g.m_280509_(bx - 1, by - 1, bx + boxW + 1, by + boxH + 1, 0x40FFFFFF);
        g.m_280509_(bx, by, bx + boxW, by + boxH, 0x20202020);
        g.m_280488_(this.f_96547_, "Icon", bx + 18, by + 4, 0xA0A0A0);
        try {
            IconRenderer.drawIcon(g, bx + boxW / 2, by + boxH / 2 + 6, this.draftIcon);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.showRestartHint && this.enableKeybindCheckbox != null) {
            int hx = this.enableKeybindCheckbox.m_252754_();
            int hy = this.enableKeybindCheckbox.m_252907_() + 22;
            MutableComponent msg = Component.m_237113_((String)"Applied on next restart").m_130940_(ChatFormatting.RED);
            g.m_280488_(this.f_96547_, msg.getString(), hx, hy, -43691);
        }
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }
}

