/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.data.icon.IconSpec;
import org.z2six.ezactions.gui.IconRenderer;
import org.z2six.ezactions.gui.noblur.NoMenuBlurScreen;

public final class IconPickerScreen
extends Screen
implements NoMenuBlurScreen {
    private final Screen parent;
    private final Consumer<IconSpec> onPick;
    private final List<String> allIcons = new ArrayList<String>();
    private String filter = "";
    private double scrollY = 0.0;
    private EditBox filterBox;
    private static final int PADDING = 12;
    private static final int CELL = 24;
    private static final int GAP = 8;
    private boolean draggingScrollbar = false;
    private int dragGrabOffsetY = 0;

    public IconPickerScreen(Screen parent, Consumer<IconSpec> onPick) {
        super((Component)Component.m_237113_((String)"Choose Icon"));
        this.parent = parent;
        this.onPick = onPick;
    }

    public static void open(Screen parent, Consumer<IconSpec> onPick) {
        Minecraft.m_91087_().m_91152_((Screen)new IconPickerScreen(parent, onPick));
    }

    protected void m_7856_() {
        try {
            this.filterBox = new EditBox(this.f_96547_, 12, 12, Math.max(120, this.f_96543_ - 24 - 20), 18, (Component)Component.m_237113_((String)"Filter"));
            this.filterBox.m_94144_(this.filter);
            this.filterBox.m_94151_(s -> {
                this.filter = s;
                double content = this.contentHeight();
                double view = this.viewHeight();
                this.scrollY = IconPickerScreen.clamp(this.scrollY, 0.0, Math.max(0.0, content - view));
            });
            this.m_142416_((GuiEventListener)this.filterBox);
            DefaultedRegistry reg = BuiltInRegistries.f_257033_;
            for (Map.Entry e : reg.m_6579_()) {
                ResourceLocation id = ((ResourceKey)e.getKey()).m_135782_();
                this.allIcons.add(id.m_135827_() + ":" + id.m_135815_());
            }
            this.allIcons.sort(String::compareToIgnoreCase);
            this.scrollY = IconPickerScreen.clamp(this.scrollY, 0.0, Math.max(0.0, this.contentHeight() - (double)this.viewHeight()));
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] IconPicker init failed: {}", (Object)"ezactions", (Object)t.toString());
        }
    }

    public boolean m_6050_(double mx, double my, double delta) {
        double view;
        double content = this.contentHeight();
        if (content > (view = (double)this.viewHeight())) {
            this.scrollY = IconPickerScreen.clamp(this.scrollY - delta * 32.0, 0.0, content - view);
        }
        return true;
    }

    public boolean m_6375_(double mx, double my, int button) {
        if (button != 0) {
            return super.m_6375_(mx, my, button);
        }
        if (this.beginScrollbarDragIfHit(mx, my)) {
            return true;
        }
        int left = 12;
        int top = 36;
        int cols = Math.max(1, (this.f_96543_ - 24) / 32);
        int x0 = left;
        int y0 = (int)((double)top - this.scrollY);
        List<String> filtered = this.filtered();
        for (int i = 0; i < filtered.size(); ++i) {
            int col = i % cols;
            int row = i / cols;
            int cx = x0 + col * 32;
            int cy = y0 + row * 32;
            if (!(mx >= (double)cx) || !(mx <= (double)(cx + 24)) || !(my >= (double)cy) || !(my <= (double)(cy + 24))) continue;
            String id = filtered.get(i);
            try {
                this.onPick.accept(IconSpec.item(id));
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] Icon onPick failed: {}", (Object)"ezactions", (Object)t.toString());
            }
            this.m_7379_();
            return true;
        }
        return super.m_6375_(mx, my, button);
    }

    public boolean m_7979_(double mx, double my, int button, double dx, double dy) {
        if (this.draggingScrollbar && button == 0) {
            try {
                this.applyDragToScroll(my);
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] IconPicker drag update failed: {}", (Object)"ezactions", (Object)t.toString());
            }
            return true;
        }
        return super.m_7979_(mx, my, button, dx, dy);
    }

    public boolean m_6348_(double mx, double my, int button) {
        if (button == 0 && this.draggingScrollbar) {
            this.draggingScrollbar = false;
            Constants.LOG.debug("[{}] IconPicker: scrollbar drag end (scrollY={})", (Object)"ezactions", (Object)this.scrollY);
            return true;
        }
        return super.m_6348_(mx, my, button);
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        g.m_280509_(0, 0, this.f_96543_, this.f_96544_, -1610612736);
        int left = 12;
        int top = 36;
        int cols = Math.max(1, (this.f_96543_ - 24) / 32);
        int x0 = left;
        int y0 = (int)((double)top - this.scrollY);
        List<String> filtered = this.filtered();
        for (int i = 0; i < filtered.size(); ++i) {
            int col = i % cols;
            int row = i / cols;
            int cx = x0 + col * 32;
            int cy = y0 + row * 32;
            IconRenderer.drawIcon(g, cx + 12, cy + 12, IconSpec.item(filtered.get(i)));
        }
        this.drawScrollbar(g);
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    private List<String> filtered() {
        if (this.filter == null || this.filter.isBlank()) {
            return this.allIcons;
        }
        String f = this.filter.toLowerCase(Locale.ROOT);
        return this.allIcons.stream().filter(s -> s.contains(f)).toList();
    }

    private int viewHeight() {
        return this.f_96544_ - 36 - 12;
    }

    private double contentHeight() {
        int cols = Math.max(1, (this.f_96543_ - 24) / 32);
        int rows = (int)Math.ceil((double)this.filtered().size() / (double)cols);
        return rows * 32;
    }

    private static double clamp(double v, double lo, double hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    private ScrollbarMetrics computeScrollbarMetrics(double content, int view) {
        ScrollbarMetrics m = new ScrollbarMetrics();
        m.barW = 6;
        m.barX = this.f_96543_ - 12 - m.barW;
        m.barY = 36;
        m.barH = view;
        double ratio = (double)view / content;
        m.knobH = Math.max(20, (int)((double)m.barH * ratio));
        double denom = Math.max(1.0, content - (double)view);
        m.knobY = (int)((double)m.barY + (double)(m.barH - m.knobH) * (this.scrollY / denom));
        return m;
    }

    private void drawScrollbar(GuiGraphics g) {
        int view;
        double content = this.contentHeight();
        if (content <= (double)(view = this.viewHeight())) {
            return;
        }
        ScrollbarMetrics m = this.computeScrollbarMetrics(content, view);
        g.m_280509_(m.barX, m.barY, m.barX + m.barW, m.barY + m.barH, 0x40000000);
        g.m_280509_(m.barX + 1, m.knobY, m.barX + m.barW - 1, m.knobY + m.knobH, -2130706433);
    }

    private boolean beginScrollbarDragIfHit(double mx, double my) {
        boolean inKnob;
        int view;
        double content = this.contentHeight();
        if (content <= (double)(view = this.viewHeight())) {
            return false;
        }
        ScrollbarMetrics m = this.computeScrollbarMetrics(content, view);
        boolean bl = inKnob = mx >= (double)(m.barX + 1) && mx <= (double)(m.barX + m.barW - 1) && my >= (double)m.knobY && my <= (double)(m.knobY + m.knobH);
        if (inKnob) {
            this.draggingScrollbar = true;
            this.dragGrabOffsetY = (int)(my - (double)m.knobY);
            Constants.LOG.debug("[{}] IconPicker: scrollbar drag start (grabOffsetY={}, scrollY={})", new Object[]{"ezactions", this.dragGrabOffsetY, this.scrollY});
            return true;
        }
        return false;
    }

    private void applyDragToScroll(double mouseY) {
        int view;
        double content = this.contentHeight();
        if (content <= (double)(view = this.viewHeight())) {
            return;
        }
        ScrollbarMetrics m = this.computeScrollbarMetrics(content, view);
        int minY = m.barY;
        int maxY = m.barY + m.barH - m.knobH;
        int newKnobY = (int)IconPickerScreen.clamp(mouseY - (double)this.dragGrabOffsetY, minY, maxY);
        double trackRange = m.barH - m.knobH;
        double t = trackRange <= 0.0 ? 0.0 : (double)(newKnobY - m.barY) / trackRange;
        double maxScroll = Math.max(0.0, content - (double)view);
        this.scrollY = IconPickerScreen.clamp(t * maxScroll, 0.0, maxScroll);
    }

    private static final class ScrollbarMetrics {
        int barX;
        int barY;
        int barW;
        int barH;
        int knobY;
        int knobH;

        private ScrollbarMetrics() {
        }
    }
}

