/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui.editor;

import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.data.click.ClickActionKey;
import org.z2six.ezactions.data.click.IClickAction;
import org.z2six.ezactions.data.icon.IconSpec;
import org.z2six.ezactions.data.menu.MenuItem;
import org.z2six.ezactions.data.menu.RadialMenu;
import org.z2six.ezactions.gui.IconRenderer;
import org.z2six.ezactions.gui.editor.IconPickerScreen;
import org.z2six.ezactions.gui.editor.KeybindPickerScreen;
import org.z2six.ezactions.gui.editor.MenuEditorScreen;
import org.z2six.ezactions.helper.InputInjector;

public final class KeyActionEditScreen
extends Screen {
    private static final int FIELD_W = 240;
    private static final int FIELD_H = 20;
    private static final int LABEL_TO_FIELD = 10;
    private static final int FIELD_TO_NEXT_LABEL = 5;
    private static final int FIRST_BUTTON_ROW_OFFSET = 10;
    private static final int BETWEEN_BUTTON_ROWS = 5;
    private static final int MAX_LEN_MAPPING = 2048;
    private final Screen parent;
    private final MenuItem editing;
    private final SaveHandler onSave;
    private String draftTitle = "";
    private String draftNote = "";
    private String draftMapping = "";
    private boolean draftToggle = false;
    private InputInjector.DeliveryMode draftMode = InputInjector.DeliveryMode.AUTO;
    private IconSpec draftIcon = IconSpec.item("minecraft:stone");
    private EditBox titleBox;
    private EditBox noteBox;
    private EditBox mappingBox;
    private CycleButton<InputInjector.DeliveryMode> modeCycle;
    private CycleButton<Boolean> toggleCycle;

    public KeyActionEditScreen(Screen parent, MenuItem editing) {
        this(parent, editing, null);
    }

    public KeyActionEditScreen(Screen parent, MenuItem editing, SaveHandler onSave) {
        super((Component)Component.m_237113_((String)(editing == null ? "Add Key Action" : "Edit Key Action")));
        IClickAction iClickAction;
        this.parent = parent;
        this.editing = editing;
        this.onSave = onSave;
        if (editing != null && (iClickAction = editing.action()) instanceof ClickActionKey) {
            ClickActionKey ck = (ClickActionKey)iClickAction;
            this.draftTitle = KeyActionEditScreen.safe(editing.title());
            try {
                this.draftNote = KeyActionEditScreen.safe(editing.note());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.draftMapping = KeyActionEditScreen.safe(ck.mappingName());
            this.draftToggle = ck.toggle();
            this.draftMode = ck.mode();
            IconSpec ic = editing.icon();
            if (ic != null) {
                this.draftIcon = ic;
            }
        }
    }

    private static String safe(String s) {
        return s == null ? "" : s;
    }

    protected void m_7856_() {
        int cx = this.f_96543_ / 2;
        int y = 52;
        this.titleBox = new EditBox(this.f_96547_, cx - 120, y, 240, 20, (Component)Component.m_237113_((String)"Title"));
        this.titleBox.m_94144_(this.draftTitle);
        this.titleBox.m_257771_((Component)Component.m_237113_((String)"Title (e.g., Inventory)"));
        this.titleBox.m_94151_(s -> {
            this.draftTitle = KeyActionEditScreen.safe(s);
        });
        this.m_142416_((GuiEventListener)this.titleBox);
        this.noteBox = new EditBox(this.f_96547_, cx - 120, y += 35, 240, 20, (Component)Component.m_237113_((String)"Note"));
        this.noteBox.m_94144_(this.draftNote);
        this.noteBox.m_257771_((Component)Component.m_237113_((String)"Optional note (tooltip in editor)"));
        this.noteBox.m_94151_(s -> {
            this.draftNote = KeyActionEditScreen.safe(s);
        });
        this.m_142416_((GuiEventListener)this.noteBox);
        this.mappingBox = new EditBox(this.f_96547_, cx - 120, y += 35, 240, 20, (Component)Component.m_237113_((String)"Mapping Name"));
        this.mappingBox.m_94199_(2048);
        this.mappingBox.m_94144_(this.draftMapping);
        this.mappingBox.m_257771_((Component)Component.m_237113_((String)"KeyMapping id (e.g., key.inventory)"));
        this.wireMappingResponder();
        this.m_142416_((GuiEventListener)this.mappingBox);
        y += 20;
        Constants.LOG.debug("[{}] KeyActionEdit(Forge1.20.1): mapping maxLen={}; draftMappingLen={}", new Object[]{"ezactions", 2048, KeyActionEditScreen.safe(this.draftMapping).length()});
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Pick from Keybinds\u2026"), b -> {
            try {
                this.f_96541_.m_91152_((Screen)new KeybindPickerScreen(this, mapping -> {
                    try {
                        this.applyPickedMapping((String)mapping);
                    }
                    catch (Throwable t) {
                        Constants.LOG.warn("[{}] KeyActionEdit(Forge1.20.1): applyPickedMapping failed: {}", (Object)"ezactions", (Object)t.toString());
                    }
                    this.f_96541_.m_91152_((Screen)this);
                }));
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] KeyActionEdit: opening KeybindPickerScreen failed: {}", (Object)"ezactions", (Object)t.toString());
            }
        }).m_252987_(cx - 120, y += 10, 240, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Choose Icon"), b -> {
            try {
                this.f_96541_.m_91152_((Screen)new IconPickerScreen(this, ic -> {
                    this.draftIcon = ic == null ? IconSpec.item("minecraft:stone") : ic;
                    this.f_96541_.m_91152_((Screen)this);
                }));
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] KeyActionEdit: opening IconPickerScreen failed: {}", (Object)"ezactions", (Object)t.toString());
            }
        }).m_252987_(cx - 120, y += 25, 240, 20).m_253136_());
        this.modeCycle = (CycleButton)this.m_142416_((GuiEventListener)CycleButton.m_168894_(dm -> Component.m_237113_((String)dm.name())).m_168961_((Object[])new InputInjector.DeliveryMode[]{InputInjector.DeliveryMode.AUTO, InputInjector.DeliveryMode.INPUT, InputInjector.DeliveryMode.TICK}).m_168948_((Object)this.draftMode).m_168930_(cx - 120, y += 25, 116, 20, (Component)Component.m_237113_((String)"Delivery")));
        this.toggleCycle = (CycleButton)this.m_142416_((GuiEventListener)CycleButton.m_168916_((boolean)this.draftToggle).m_168930_(cx + 4, y, 116, 20, (Component)Component.m_237113_((String)"Toggle")));
        int totalW = 256;
        int leftX = cx - totalW / 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> this.onSavePressed()).m_252987_(leftX, y += 25, 80, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> this.m_7379_()).m_252987_(leftX + 80 + 8, y, 80, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), b -> this.f_96541_.m_91152_(this.parent)).m_252987_(leftX + 176, y, 80, 20).m_253136_());
    }

    private void wireMappingResponder() {
        if (this.mappingBox == null) {
            return;
        }
        this.mappingBox.m_94151_(s -> {
            this.draftMapping = KeyActionEditScreen.safe(s);
        });
    }

    private void applyPickedMapping(String mapping) {
        if (mapping == null) {
            return;
        }
        String m = KeyActionEditScreen.safe(mapping).trim();
        if (m.isEmpty()) {
            return;
        }
        this.draftMapping = m;
        if (this.mappingBox != null) {
            try {
                int need = Math.max(2048, m.length());
                this.mappingBox.m_94151_(s -> {});
                this.mappingBox.m_94199_(need);
                this.mappingBox.m_94144_(m);
                this.wireMappingResponder();
                Constants.LOG.debug("[{}] KeyActionEdit(Forge1.20.1): applied picked mapping len={} boxMax>=len={}", new Object[]{"ezactions", m.length(), need});
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] KeyActionEdit(Forge1.20.1): failed applying picked mapping to box: {}", (Object)"ezactions", (Object)t.toString());
                try {
                    this.wireMappingResponder();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static String chooseBestMapping(String fromBox, String fromDraft) {
        String a = KeyActionEditScreen.safe(fromBox).trim();
        String b = KeyActionEditScreen.safe(fromDraft).trim();
        if (a.isEmpty() && b.isEmpty()) {
            return "";
        }
        if (a.isEmpty()) {
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        if (a.equals(b)) {
            return a;
        }
        if (b.length() > a.length()) {
            return b;
        }
        if (a.length() > b.length()) {
            return a;
        }
        return a;
    }

    private void onSavePressed() {
        try {
            boolean ok;
            this.draftTitle = KeyActionEditScreen.safe(this.titleBox == null ? this.draftTitle : this.titleBox.m_94155_()).trim();
            this.draftNote = KeyActionEditScreen.safe(this.noteBox == null ? this.draftNote : this.noteBox.m_94155_()).trim();
            String boxMapping = KeyActionEditScreen.safe(this.mappingBox == null ? "" : this.mappingBox.m_94155_());
            String chosenMapping = KeyActionEditScreen.chooseBestMapping(boxMapping, this.draftMapping);
            if (!KeyActionEditScreen.safe(boxMapping).trim().equals(KeyActionEditScreen.safe(this.draftMapping).trim())) {
                Constants.LOG.debug("[{}] KeyActionEdit(Forge1.20.1): mapping mismatch on save (boxLen={}, draftLen={}, chosenLen={}). box='{}' draft='{}'.", new Object[]{"ezactions", KeyActionEditScreen.safe(boxMapping).trim().length(), KeyActionEditScreen.safe(this.draftMapping).trim().length(), chosenMapping.length(), KeyActionEditScreen.safe(boxMapping).trim(), KeyActionEditScreen.safe(this.draftMapping).trim()});
            }
            this.draftMapping = chosenMapping;
            this.draftMode = this.modeCycle == null ? this.draftMode : (InputInjector.DeliveryMode)((Object)this.modeCycle.m_168883_());
            boolean bl = this.draftToggle = this.toggleCycle != null && Boolean.TRUE.equals(this.toggleCycle.m_168883_());
            if (this.draftTitle.isEmpty() || this.draftMapping.isEmpty()) {
                Constants.LOG.warn("[{}] KeyActionEdit: Title or Mapping empty; ignoring save.", (Object)"ezactions");
                return;
            }
            MenuItem newItem = new MenuItem(this.editing != null ? this.editing.id() : MenuEditorScreen.freshId("key"), this.draftTitle, this.draftNote, this.draftIcon, (IClickAction)new ClickActionKey(this.draftMapping, this.draftToggle, this.draftMode), List.of());
            if (this.onSave != null) {
                this.onSave.accept(newItem, this.editing);
                this.f_96541_.m_91152_(this.parent);
                return;
            }
            boolean bl2 = ok = this.editing == null ? RadialMenu.addToCurrent(newItem) : RadialMenu.replaceInCurrent(this.editing.id(), newItem);
            if (!ok) {
                Constants.LOG.info("[{}] Page full or replace failed for '{}'.", (Object)"ezactions", (Object)newItem.title());
            }
            this.f_96541_.m_91152_(this.parent);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] KeyActionEdit onSave failed: {}", (Object)"ezactions", (Object)t.toString());
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        g.m_280509_(0, 0, this.f_96543_, this.f_96544_, -2013265920);
        g.m_280509_(12, 52, this.f_96543_ - 12, this.f_96544_ - 36, -1072689136);
        g.m_280137_(this.f_96547_, this.f_96539_.getString(), this.f_96543_ / 2, 20, 0xFFFFFF);
        if (this.titleBox != null) {
            g.m_280488_(this.f_96547_, "Title:", this.titleBox.m_252754_(), this.titleBox.m_252907_() - 10, 0xA0A0A0);
        }
        if (this.noteBox != null) {
            g.m_280488_(this.f_96547_, "Note:", this.noteBox.m_252754_(), this.noteBox.m_252907_() - 10, 0xA0A0A0);
        }
        if (this.mappingBox != null) {
            g.m_280488_(this.f_96547_, "Mapping Name:", this.mappingBox.m_252754_(), this.mappingBox.m_252907_() - 10, 0xA0A0A0);
        }
        try {
            IconRenderer.drawIcon(g, this.f_96543_ - 28, 28, this.draftIcon);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.mappingBox != null) {
                int visibleW;
                int textW;
                String val;
                boolean over;
                int bx = this.mappingBox.m_252754_();
                int by = this.mappingBox.m_252907_();
                int bw = this.mappingBox.m_5711_();
                int bh = this.mappingBox.m_93694_();
                boolean bl = over = mouseX >= bx && mouseX < bx + bw && mouseY >= by && mouseY < by + bh;
                if (over && !(val = KeyActionEditScreen.safe(this.mappingBox.m_94155_()).trim()).isEmpty() && (textW = this.f_96547_.m_92895_(val)) > (visibleW = Math.max(1, bw - 8))) {
                    g.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)val), mouseX, mouseY);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    @FunctionalInterface
    public static interface SaveHandler
    extends BiConsumer<MenuItem, MenuItem> {
    }
}

