/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui.editor;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.gui.noblur.NoMenuBlurScreen;

public final class KeybindPickerScreen
extends Screen
implements NoMenuBlurScreen {
    private final Screen parent;
    private final Consumer<String> onPick;
    private static final int PADDING = 12;
    private static final int FILTER_H = 20;
    private static final int FILTER_GAP = 8;
    private static final int ROW_H = 20;
    private static final int BUTTON_W = 60;
    private int listTopPx = 40;
    private double scrollY = 0.0;
    private final List<Row> rows = new ArrayList<Row>();
    private EditBox filterBox;
    private String filterText = "";
    private boolean draggingScrollbar = false;
    private int dragGrabOffsetY = 0;

    public KeybindPickerScreen(Screen parent, Consumer<String> onPick) {
        super((Component)Component.m_237113_((String)"Choose Keybinding"));
        this.parent = parent;
        this.onPick = onPick;
    }

    public static void open(Screen parent, Consumer<String> onPick) {
        Minecraft.m_91087_().m_91152_((Screen)new KeybindPickerScreen(parent, onPick));
    }

    protected void m_7856_() {
        try {
            this.listTopPx = 40;
            this.filterBox = new EditBox(this.f_96547_, 12, 12, Math.max(60, this.f_96543_ - 24), 20, (Component)Component.m_237113_((String)"Filter"));
            this.filterBox.m_257771_((Component)Component.m_237113_((String)"Filter (key id / name / mod)\u2026"));
            this.filterBox.m_94144_(KeybindPickerScreen.safe(this.filterText));
            this.filterBox.m_94151_(s -> {
                this.filterText = KeybindPickerScreen.safe(s);
                this.rebuildRows();
            });
            this.m_142416_((GuiEventListener)this.filterBox);
            this.rebuildRows();
            Constants.LOG.debug("[{}] KeybindPicker init OK (rows={}, filter='{}')", new Object[]{"ezactions", this.rows.size(), KeybindPickerScreen.safe(this.filterText).trim()});
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] KeybindPicker init failed: {}", (Object)"ezactions", (Object)t.toString());
        }
    }

    private void rebuildRows() {
        try {
            Options opts = Objects.requireNonNull(Minecraft.m_91087_().f_91066_);
            KeyMapping[] all = Objects.requireNonNull(opts.f_92059_);
            String q = KeybindPickerScreen.normalize(this.filterText);
            List<String> tokens = KeybindPickerScreen.tokenize(q);
            HashMap<String, List> byMod = new HashMap<String, List>();
            int total = 0;
            int kept = 0;
            for (KeyMapping km2 : all) {
                String groupName;
                if (km2 == null) continue;
                ++total;
                String mappingId = KeybindPickerScreen.safe(km2.m_90860_());
                String localizedName = KeybindPickerScreen.safe(Component.m_237115_((String)mappingId).getString());
                String categoryKey = KeybindPickerScreen.safe(km2.m_90858_());
                String categoryLocalized = KeybindPickerScreen.safe(Component.m_237115_((String)categoryKey).getString());
                ModMeta mod = KeybindPickerScreen.resolveModMeta(km2);
                String modId = KeybindPickerScreen.safe(mod.modId);
                String modName = KeybindPickerScreen.safe(mod.displayName);
                String string = groupName = modName.isEmpty() ? "Minecraft" : modName;
                if (!tokens.isEmpty()) {
                    String hay = (mappingId + " " + localizedName + " " + modId + " " + modName + " " + categoryKey + " " + categoryLocalized).toLowerCase(Locale.ROOT);
                    boolean ok = true;
                    for (String tok : tokens) {
                        if (tok.isEmpty() || hay.contains(tok)) continue;
                        ok = false;
                        break;
                    }
                    if (!ok) continue;
                }
                ++kept;
                byMod.computeIfAbsent(groupName, k -> new ArrayList()).add(km2);
            }
            ArrayList groups = new ArrayList(byMod.keySet());
            groups.sort(String.CASE_INSENSITIVE_ORDER);
            this.rows.clear();
            for (String group : groups) {
                List list = (List)byMod.get(group);
                if (list == null || list.isEmpty()) continue;
                this.rows.add(new Row(true, (Component)Component.m_237113_((String)group), null, group));
                list.sort(Comparator.comparing(km -> {
                    try {
                        return Component.m_237115_((String)KeybindPickerScreen.safe(km.m_90860_())).getString();
                    }
                    catch (Throwable ignored) {
                        return KeybindPickerScreen.safe(km.m_90860_());
                    }
                }, String.CASE_INSENSITIVE_ORDER));
                for (KeyMapping km3 : list) {
                    this.rows.add(new Row(false, (Component)Component.m_237115_((String)KeybindPickerScreen.safe(km3.m_90860_())), km3, group));
                }
            }
            this.scrollY = KeybindPickerScreen.clamp(this.scrollY, 0.0, Math.max(0, this.rows.size() * 20 - this.viewHeight()));
            Constants.LOG.debug("[{}] KeybindPicker rebuildRows: total={}, kept={}, groups={}, rows={}, filter='{}'", new Object[]{"ezactions", total, kept, groups.size(), this.rows.size(), q});
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] KeybindPicker rebuildRows failed: {}", (Object)"ezactions", (Object)t.toString());
        }
    }

    public boolean m_6050_(double mx, double my, double delta) {
        try {
            double view;
            boolean overList = my >= (double)this.listTopPx && my <= (double)(this.f_96544_ - 12);
            boolean overScrollbar = this.isOverScrollbar(mx, my);
            if (!overList && !overScrollbar) {
                return super.m_6050_(mx, my, delta);
            }
            double content = this.rows.size() * 20;
            if (content > (view = (double)this.viewHeight())) {
                this.scrollY = KeybindPickerScreen.clamp(this.scrollY - delta * 32.0, 0.0, content - view);
            }
            return true;
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] KeybindPicker mouseScrolled failed: {}", (Object)"ezactions", (Object)t.toString());
            return true;
        }
    }

    public boolean m_6375_(double mx, double my, int button) {
        try {
            if (super.m_6375_(mx, my, button)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (button != 0) {
            return false;
        }
        if (this.beginScrollbarDragIfHit(mx, my)) {
            return true;
        }
        int x = 12;
        int y = (int)((double)this.listTopPx - this.scrollY);
        int usableW = this.f_96543_ - 24;
        for (int i = 0; i < this.rows.size(); ++i) {
            Row r = this.rows.get(i);
            int ry = y + i * 20;
            if (ry + 20 < this.listTopPx || ry > this.f_96544_ - 12 || r.header) continue;
            int btnX = x + Math.min(usableW, 360);
            int btnY = ry + 3;
            if (!(mx >= (double)btnX) || !(mx <= (double)(btnX + 60)) || !(my >= (double)btnY) || !(my <= (double)(btnY + 14))) continue;
            try {
                String mappingKey = r.mapping.m_90860_();
                Constants.LOG.info("[{}] KeybindPicker: picked {}", (Object)"ezactions", (Object)mappingKey);
                this.onPick.accept(mappingKey);
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] KeybindPicker onPick failed: {}", (Object)"ezactions", (Object)t.toString());
            }
            this.m_7379_();
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mx, double my, int button) {
        if (button == 0 && this.draggingScrollbar) {
            this.draggingScrollbar = false;
            Constants.LOG.debug("[{}] KeybindPicker: scrollbar drag end (scrollY={})", (Object)"ezactions", (Object)this.scrollY);
            return true;
        }
        return super.m_6348_(mx, my, button);
    }

    public boolean m_7979_(double mx, double my, int button, double dx, double dy) {
        if (this.draggingScrollbar && button == 0) {
            try {
                this.applyDragToScroll(my);
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] KeybindPicker drag update failed: {}", (Object)"ezactions", (Object)t.toString());
            }
            return true;
        }
        return super.m_7979_(mx, my, button, dx, dy);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        try {
            if (super.m_5534_(codePoint, modifiers)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        try {
            if (super.m_7933_(keyCode, scanCode, modifiers)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        g.m_280509_(0, 0, this.f_96543_, this.f_96544_, -1610612736);
        super.m_88315_(g, mouseX, mouseY, partialTick);
        int x = 12;
        int y = (int)((double)this.listTopPx - this.scrollY);
        int usableW = this.f_96543_ - 24;
        for (int i = 0; i < this.rows.size(); ++i) {
            Row r = this.rows.get(i);
            int ry = y + i * 20;
            if (ry + 20 < this.listTopPx || ry > this.f_96544_ - 12) continue;
            if (r.header) {
                g.m_280430_(this.f_96547_, r.label, x, ry + 4, 0xFFFFAA);
                g.m_280509_(x, ry + 20 - 2, x + usableW, ry + 20 - 1, 0x40FFFFFF);
                continue;
            }
            g.m_280430_(this.f_96547_, r.label, x, ry + 5, 0xFFFFFF);
            int btnX = x + Math.min(usableW, 360);
            int btnY = ry + 3;
            int btnW = 60;
            int btnH = 14;
            g.m_280509_(btnX, btnY, btnX + btnW, btnY + btnH, 0x40000000);
            MutableComponent b = Component.m_237113_((String)"Use");
            int tw = this.f_96547_.m_92852_((FormattedText)b);
            g.m_280430_(this.f_96547_, (Component)b, btnX + (btnW - tw) / 2, btnY + 5, 0xFFFFFF);
        }
        this.drawScrollbar(g);
    }

    private int viewHeight() {
        return Math.max(1, this.f_96544_ - 12 - this.listTopPx);
    }

    private static double clamp(double v, double lo, double hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    private boolean isOverScrollbar(double mx, double my) {
        int view;
        double content = this.rows.size() * 20;
        if (content <= (double)(view = this.viewHeight())) {
            return false;
        }
        ScrollbarMetrics m = this.computeScrollbarMetrics(content, view);
        return mx >= (double)m.barX && mx <= (double)(m.barX + m.barW) && my >= (double)m.barY && my <= (double)(m.barY + m.barH);
    }

    private void drawScrollbar(GuiGraphics g) {
        int view;
        double content = this.rows.size() * 20;
        if (content <= (double)(view = this.viewHeight())) {
            return;
        }
        ScrollbarMetrics m = this.computeScrollbarMetrics(content, view);
        g.m_280509_(m.barX, m.barY, m.barX + m.barW, m.barY + m.barH, 0x40000000);
        g.m_280509_(m.barX + 1, m.knobY, m.barX + m.barW - 1, m.knobY + m.knobH, -2130706433);
    }

    private ScrollbarMetrics computeScrollbarMetrics(double content, int view) {
        ScrollbarMetrics m = new ScrollbarMetrics();
        m.barW = 6;
        m.barX = this.f_96543_ - 12 - m.barW;
        m.barY = this.listTopPx;
        m.barH = view;
        double ratio = (double)view / content;
        m.knobH = Math.max(20, (int)((double)m.barH * ratio));
        double denom = Math.max(1.0, content - (double)view);
        m.knobY = (int)((double)m.barY + (double)(m.barH - m.knobH) * (this.scrollY / denom));
        return m;
    }

    private boolean beginScrollbarDragIfHit(double mx, double my) {
        boolean inKnob;
        int view;
        double content = this.rows.size() * 20;
        if (content <= (double)(view = this.viewHeight())) {
            return false;
        }
        ScrollbarMetrics m = this.computeScrollbarMetrics(content, view);
        boolean bl = inKnob = mx >= (double)(m.barX + 1) && mx <= (double)(m.barX + m.barW - 1) && my >= (double)m.knobY && my <= (double)(m.knobY + m.knobH);
        if (inKnob) {
            this.draggingScrollbar = true;
            this.dragGrabOffsetY = (int)(my - (double)m.knobY);
            Constants.LOG.debug("[{}] KeybindPicker: scrollbar drag start (grabOffsetY={}, scrollY={})", new Object[]{"ezactions", this.dragGrabOffsetY, this.scrollY});
            return true;
        }
        return false;
    }

    private void applyDragToScroll(double mouseY) {
        int view;
        double content = this.rows.size() * 20;
        if (content <= (double)(view = this.viewHeight())) {
            return;
        }
        ScrollbarMetrics m = this.computeScrollbarMetrics(content, view);
        int minY = m.barY;
        int maxY = m.barY + m.barH - m.knobH;
        int newKnobY = (int)KeybindPickerScreen.clamp(mouseY - (double)this.dragGrabOffsetY, minY, maxY);
        double trackRange = m.barH - m.knobH;
        double t = trackRange <= 0.0 ? 0.0 : (double)(newKnobY - m.barY) / trackRange;
        double maxScroll = Math.max(0.0, content - (double)view);
        this.scrollY = KeybindPickerScreen.clamp(t * maxScroll, 0.0, maxScroll);
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    private static String safe(String s) {
        return s == null ? "" : s;
    }

    private static String normalize(String s) {
        return KeybindPickerScreen.safe(s).trim().toLowerCase(Locale.ROOT);
    }

    private static List<String> tokenize(String qLower) {
        if (qLower == null) {
            return List.of();
        }
        String q = qLower.trim();
        if (q.isEmpty()) {
            return List.of();
        }
        String[] parts = q.split("\\s+");
        ArrayList<String> out = new ArrayList<String>(parts.length);
        for (String p : parts) {
            String t;
            String string = t = p == null ? "" : p.trim();
            if (t.isEmpty()) continue;
            out.add(t);
        }
        return out;
    }

    private static ModMeta resolveModMeta(KeyMapping km) {
        try {
            if (km == null) {
                return new ModMeta("", "");
            }
            String nameKey = KeybindPickerScreen.safe(km.m_90860_());
            String cand = KeybindPickerScreen.extractModIdFromKeyName(nameKey);
            ModMeta meta = KeybindPickerScreen.lookupMod(cand);
            if (!meta.displayName.isEmpty()) {
                return meta;
            }
            String catKey = KeybindPickerScreen.safe(km.m_90858_());
            cand = KeybindPickerScreen.extractModIdFromCategoryKey(catKey);
            meta = KeybindPickerScreen.lookupMod(cand);
            if (!meta.displayName.isEmpty()) {
                return meta;
            }
            return new ModMeta("", "Minecraft");
        }
        catch (Throwable t) {
            Constants.LOG.debug("[{}] resolveModMeta failed safely: {}", (Object)"ezactions", (Object)t.toString());
            return new ModMeta("", "Minecraft");
        }
    }

    private static String extractModIdFromKeyName(String key) {
        try {
            if (key == null) {
                return "";
            }
            if (!key.startsWith("key.")) {
                return "";
            }
            String rest = key.substring("key.".length());
            int dot = rest.indexOf(46);
            if (dot <= 0) {
                return "";
            }
            String seg = rest.substring(0, dot).trim();
            return seg;
        }
        catch (Throwable ignored) {
            return "";
        }
    }

    private static String extractModIdFromCategoryKey(String catKey) {
        try {
            if (catKey == null) {
                return "";
            }
            String pfx = "key.categories.";
            if (!catKey.startsWith("key.categories.")) {
                return "";
            }
            String rest = catKey.substring("key.categories.".length());
            int dot = rest.indexOf(46);
            String seg = dot >= 0 ? rest.substring(0, dot) : rest;
            seg = seg.trim();
            return seg;
        }
        catch (Throwable ignored) {
            return "";
        }
    }

    private static ModMeta lookupMod(String modIdCandidate) {
        try {
            String display;
            String id = KeybindPickerScreen.safe(modIdCandidate).trim();
            if (id.isEmpty()) {
                return new ModMeta("", "");
            }
            Optional<Object> infoOpt = Optional.empty();
            try {
                IModInfo info;
                Optional contOpt = ModList.get().getModContainerById(id);
                if (contOpt.isPresent() && (info = ((ModContainer)contOpt.get()).getModInfo()) != null) {
                    infoOpt = Optional.of(info);
                }
            }
            catch (Throwable contOpt) {
                // empty catch block
            }
            if (infoOpt.isPresent() && !(display = KeybindPickerScreen.safe(((IModInfo)infoOpt.get()).getDisplayName()).trim()).isEmpty()) {
                return new ModMeta(id, display);
            }
            return new ModMeta(id, id);
        }
        catch (Throwable t) {
            return new ModMeta("", "");
        }
    }

    private static final class ModMeta {
        final String modId;
        final String displayName;

        ModMeta(String modId, String displayName) {
            this.modId = modId;
            this.displayName = displayName;
        }
    }

    private static final class Row {
        final boolean header;
        final Component label;
        final KeyMapping mapping;
        final String groupName;

        Row(boolean header, Component label, KeyMapping mapping, String groupName) {
            this.header = header;
            this.label = label;
            this.mapping = mapping;
            this.groupName = groupName;
        }
    }

    private static final class ScrollbarMetrics {
        int barX;
        int barY;
        int barW;
        int barH;
        int knobY;
        int knobH;

        private ScrollbarMetrics() {
        }
    }
}

