/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui.editor.config;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.config.ConfigIO;
import org.z2six.ezactions.config.DesignClientConfig;
import org.z2six.ezactions.config.GeneralClientConfig;
import org.z2six.ezactions.config.RadialAnimConfig;
import org.z2six.ezactions.config.RadialConfig;
import org.z2six.ezactions.gui.editor.config.ColorPickerScreen;
import org.z2six.ezactions.gui.editor.config.ColorUtil;

public final class ConfigScreen
extends Screen {
    private final Screen parent;
    private Section section = Section.GENERAL;
    private boolean skipReloadDraftsOnce = false;
    private boolean draftMoveWhileRadialOpen;
    private int draftCmdVisibleLines;
    private boolean draftAnimEnabled;
    private boolean draftAnimOpenClose;
    private boolean draftAnimHover;
    private double draftHoverGrowPct;
    private int draftOpenCloseMs;
    private int draftDeadzone;
    private int draftBaseOuterRadius;
    private int draftRingThickness;
    private int draftScaleStartThreshold;
    private int draftScalePerItem;
    private int draftRingColor;
    private int draftHoverColor;
    private CycleButton<Boolean> wMoveWhileOpen;
    private EditBox wCmdLines;
    private CycleButton<Boolean> wAnimEnabled;
    private CycleButton<Boolean> wAnimOpenClose;
    private CycleButton<Boolean> wAnimHover;
    private EditBox wHoverGrowPct;
    private EditBox wOpenCloseMs;
    private EditBox wDeadzone;
    private EditBox wOuter;
    private EditBox wThick;
    private EditBox wScaleStart;
    private EditBox wScalePer;
    private Button wRingPick;
    private Button wHoverPick;

    public ConfigScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"EZ Actions \u2013 Configuration"));
        this.parent = parent;
    }

    protected void m_7856_() {
        if (!this.skipReloadDraftsOnce) {
            this.readCurrentIntoDrafts();
        } else {
            this.skipReloadDraftsOnce = false;
        }
        this.buildUI();
    }

    private void readCurrentIntoDrafts() {
        try {
            this.draftMoveWhileRadialOpen = GeneralClientConfig.isMoveWhileRadialOpen();
            this.draftCmdVisibleLines = GeneralClientConfig.getCommandEditorVisibleLines();
            this.draftAnimEnabled = RadialAnimConfig.CONFIG.animationsEnabled();
            this.draftAnimOpenClose = RadialAnimConfig.CONFIG.animOpenClose();
            this.draftAnimHover = RadialAnimConfig.CONFIG.animHover();
            this.draftHoverGrowPct = RadialAnimConfig.CONFIG.hoverGrowPct();
            this.draftOpenCloseMs = RadialAnimConfig.CONFIG.openCloseMs();
            this.draftDeadzone = (Integer)DesignClientConfig.deadzone.get();
            this.draftBaseOuterRadius = (Integer)DesignClientConfig.baseOuterRadius.get();
            this.draftRingThickness = (Integer)DesignClientConfig.ringThickness.get();
            this.draftScaleStartThreshold = (Integer)DesignClientConfig.scaleStartThreshold.get();
            this.draftScalePerItem = (Integer)DesignClientConfig.scalePerItem.get();
            this.draftRingColor = (Integer)DesignClientConfig.ringColor.get();
            this.draftHoverColor = (Integer)DesignClientConfig.hoverColor.get();
        }
        catch (Throwable t) {
            try {
                Constants.LOG.warn("[{}] ConfigScreen: failed reading current specs: {}", (Object)"ezactions", (Object)t.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void buildUI() {
        this.m_169413_();
        int PAD = 12;
        int LEFT_W = 160;
        int FIELD_W = 160;
        int FIELD_H = 20;
        int RIGHT_INNER_PAD = 16;
        int HEADER_Y = 20;
        int FORM_TOP_GAP = 18;
        int x = 12;
        int y = 12;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"General"), b -> {
            this.section = Section.GENERAL;
            this.buildUI();
        }).m_252987_(x, y, 160, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Animations"), b -> {
            this.section = Section.ANIM;
            this.buildUI();
        }).m_252987_(x, y += 24, 160, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Design"), b -> {
            this.section = Section.DESIGN;
            this.buildUI();
        }).m_252987_(x, y += 24, 160, 20).m_253136_());
        int bottom = this.f_96544_ - 12;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> this.onSave()).m_252987_(x, bottom - 22, 160, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), b -> this.m_7379_()).m_252987_(x, bottom - 22 - 24, 160, 20).m_253136_());
        int rightPanelX = 184;
        int formX = rightPanelX + 16;
        int formY = 38;
        int row = 0;
        switch (this.section) {
            case GENERAL: {
                this.wMoveWhileOpen = (CycleButton)this.m_142416_((GuiEventListener)CycleButton.m_168916_((boolean)this.draftMoveWhileRadialOpen).m_168930_(formX, formY + row * 28, 160, 20, (Component)Component.m_237113_((String)"Move While Radial Open")));
                this.wCmdLines = new EditBox(this.f_96547_, formX, formY + ++row * 28, 160, 20, (Component)Component.m_237113_((String)""));
                this.wCmdLines.m_94144_(Integer.toString(this.draftCmdVisibleLines));
                this.m_142416_((GuiEventListener)this.wCmdLines);
                break;
            }
            case ANIM: {
                this.wAnimEnabled = (CycleButton)this.m_142416_((GuiEventListener)CycleButton.m_168916_((boolean)this.draftAnimEnabled).m_168930_(formX, formY + row * 28, 160, 20, (Component)Component.m_237113_((String)"Animations Enabled")));
                this.wAnimOpenClose = (CycleButton)this.m_142416_((GuiEventListener)CycleButton.m_168916_((boolean)this.draftAnimOpenClose).m_168930_(formX, formY + ++row * 28, 160, 20, (Component)Component.m_237113_((String)"Open/Close Wipe")));
                this.wAnimHover = (CycleButton)this.m_142416_((GuiEventListener)CycleButton.m_168916_((boolean)this.draftAnimHover).m_168930_(formX, formY + ++row * 28, 160, 20, (Component)Component.m_237113_((String)"Hover Animation")));
                this.wHoverGrowPct = new EditBox(this.f_96547_, formX, formY + ++row * 28, 160, 20, (Component)Component.m_237113_((String)""));
                this.wHoverGrowPct.m_94144_(Double.toString(this.draftHoverGrowPct));
                this.m_142416_((GuiEventListener)this.wHoverGrowPct);
                this.wOpenCloseMs = new EditBox(this.f_96547_, formX, formY + ++row * 28, 160, 20, (Component)Component.m_237113_((String)""));
                this.wOpenCloseMs.m_94144_(Integer.toString(this.draftOpenCloseMs));
                this.m_142416_((GuiEventListener)this.wOpenCloseMs);
                break;
            }
            case DESIGN: {
                this.wDeadzone = this.addIntBox(formX, formY + row * 28, 160, 20, this.draftDeadzone);
                this.wOuter = this.addIntBox(formX, formY + ++row * 28, 160, 20, this.draftBaseOuterRadius);
                this.wThick = this.addIntBox(formX, formY + ++row * 28, 160, 20, this.draftRingThickness);
                this.wScaleStart = this.addIntBox(formX, formY + ++row * 28, 160, 20, this.draftScaleStartThreshold);
                this.wScalePer = this.addIntBox(formX, formY + ++row * 28, 160, 20, this.draftScalePerItem);
                int btnY = formY + ++row * 28;
                this.wRingPick = Button.m_253074_((Component)Component.m_237113_((String)"Pick Ring Color\u2026"), b -> {
                    this.skipReloadDraftsOnce = true;
                    this.f_96541_.m_91152_((Screen)new ColorPickerScreen(this, this.draftRingColor, argb -> {
                        this.draftRingColor = argb;
                    }));
                }).m_252987_(formX, btnY, 160, 20).m_253136_();
                this.m_142416_((GuiEventListener)this.wRingPick);
                this.wHoverPick = Button.m_253074_((Component)Component.m_237113_((String)"Pick Hover Color\u2026"), b -> {
                    this.skipReloadDraftsOnce = true;
                    this.f_96541_.m_91152_((Screen)new ColorPickerScreen(this, this.draftHoverColor, argb -> {
                        this.draftHoverColor = argb;
                    }));
                }).m_252987_(formX, formY + ++row * 28, 160, 20).m_253136_();
                this.m_142416_((GuiEventListener)this.wHoverPick);
            }
        }
    }

    private EditBox addIntBox(int x, int y, int w, int h, int value) {
        EditBox eb = new EditBox(this.f_96547_, x, y, w, h, (Component)Component.m_237113_((String)""));
        eb.m_94144_(Integer.toString(value));
        this.m_142416_((GuiEventListener)eb);
        return eb;
    }

    private void onSave() {
        try {
            switch (this.section) {
                case GENERAL: {
                    this.draftMoveWhileRadialOpen = this.wMoveWhileOpen != null && Boolean.TRUE.equals(this.wMoveWhileOpen.m_168883_());
                    this.draftCmdVisibleLines = ConfigScreen.clamp(ConfigScreen.parseSafeInt(this.wCmdLines, 5), 1, 20);
                    GeneralClientConfig.INSTANCE.moveWhileRadialOpen.set((Object)this.draftMoveWhileRadialOpen);
                    GeneralClientConfig.INSTANCE.commandEditorVisibleLines.set((Object)this.draftCmdVisibleLines);
                    ConfigIO.saveNow(ConfigIO.Section.GENERAL);
                    break;
                }
                case ANIM: {
                    this.draftAnimEnabled = this.wAnimEnabled != null && Boolean.TRUE.equals(this.wAnimEnabled.m_168883_());
                    this.draftAnimOpenClose = this.wAnimOpenClose != null && Boolean.TRUE.equals(this.wAnimOpenClose.m_168883_());
                    this.draftAnimHover = this.wAnimHover != null && Boolean.TRUE.equals(this.wAnimHover.m_168883_());
                    this.draftHoverGrowPct = ConfigScreen.clampDouble(ConfigScreen.parseSafeDouble(this.wHoverGrowPct, 0.05), 0.0, 0.5);
                    this.draftOpenCloseMs = ConfigScreen.clamp(ConfigScreen.parseSafeInt(this.wOpenCloseMs, 125), 0, 2000);
                    RadialAnimConfig.CONFIG.animationsEnabled.set((Object)this.draftAnimEnabled);
                    RadialAnimConfig.CONFIG.animOpenClose.set((Object)this.draftAnimOpenClose);
                    RadialAnimConfig.CONFIG.animHover.set((Object)this.draftAnimHover);
                    RadialAnimConfig.CONFIG.hoverGrowPct.set((Object)this.draftHoverGrowPct);
                    RadialAnimConfig.CONFIG.openCloseMs.set((Object)this.draftOpenCloseMs);
                    ConfigIO.saveNow(ConfigIO.Section.ANIM);
                    break;
                }
                case DESIGN: {
                    this.draftDeadzone = ConfigScreen.clamp(ConfigScreen.parseSafeInt(this.wDeadzone, 18), 0, 90);
                    this.draftBaseOuterRadius = ConfigScreen.clamp(ConfigScreen.parseSafeInt(this.wOuter, 72), 24, 512);
                    this.draftRingThickness = ConfigScreen.clamp(ConfigScreen.parseSafeInt(this.wThick, 28), 6, 256);
                    this.draftScaleStartThreshold = ConfigScreen.clamp(ConfigScreen.parseSafeInt(this.wScaleStart, 8), 0, 128);
                    this.draftScalePerItem = ConfigScreen.clamp(ConfigScreen.parseSafeInt(this.wScalePer, 6), 0, 100);
                    DesignClientConfig.deadzone.set((Object)this.draftDeadzone);
                    DesignClientConfig.baseOuterRadius.set((Object)this.draftBaseOuterRadius);
                    DesignClientConfig.ringThickness.set((Object)this.draftRingThickness);
                    DesignClientConfig.scaleStartThreshold.set((Object)this.draftScaleStartThreshold);
                    DesignClientConfig.scalePerItem.set((Object)this.draftScalePerItem);
                    DesignClientConfig.ringColor.set((Object)this.draftRingColor);
                    DesignClientConfig.hoverColor.set((Object)this.draftHoverColor);
                    ConfigIO.saveNow(ConfigIO.Section.DESIGN);
                    RadialConfig.invalidate();
                }
            }
            this.buildUI();
            try {
                Constants.LOG.info("[{}] Config saved (section: {})", (Object)"ezactions", (Object)this.section.name());
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable t) {
            try {
                Constants.LOG.warn("[{}] Config save failed: {}", (Object)"ezactions", (Object)t.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int PAD = 12;
        int LEFT_W = 160;
        int RIGHT_INNER_PAD = 16;
        int LABEL_COLOR = 0xA0A0A0;
        g.m_280509_(0, 0, this.f_96543_, this.f_96544_, -2013265920);
        g.m_280509_(12, 12, 172, this.f_96544_ - 12, -1072689136);
        int rightPanelX = 184;
        g.m_280509_(rightPanelX, 12, this.f_96543_ - 12, this.f_96544_ - 12, -1072689136);
        g.m_280137_(this.f_96547_, this.f_96539_.getString(), this.f_96543_ / 2, 8, 0xFFFFFF);
        String sec = switch (this.section) {
            default -> throw new IncompatibleClassChangeError();
            case Section.GENERAL -> "General";
            case Section.ANIM -> "Animations";
            case Section.DESIGN -> "Design";
        };
        int headerX = rightPanelX + 16;
        int headerY = 20;
        g.m_280488_(this.f_96547_, sec, headerX, headerY, 0xA0A0A0);
        switch (this.section) {
            case GENERAL: {
                this.drawRightLabel(g, this.wCmdLines, "Visible lines (1\u201320)");
                break;
            }
            case ANIM: {
                this.drawRightLabel(g, this.wHoverGrowPct, "Hover Grow % (0.0\u20130.5)");
                this.drawRightLabel(g, this.wOpenCloseMs, "Open/Close (ms)");
                break;
            }
            case DESIGN: {
                int y;
                int x;
                this.drawRightLabel(g, this.wDeadzone, "Deadzone");
                this.drawRightLabel(g, this.wOuter, "Outer Radius");
                this.drawRightLabel(g, this.wThick, "Ring Thickness");
                this.drawRightLabel(g, this.wScaleStart, "Scale Start");
                this.drawRightLabel(g, this.wScalePer, "Scale / Item");
                if (this.wRingPick != null) {
                    x = this.wRingPick.m_252754_() + this.wRingPick.m_5711_() + 8;
                    y = this.wRingPick.m_252907_();
                    this.drawColorPreview(g, x, y, this.draftRingColor);
                    g.m_280488_(this.f_96547_, ColorUtil.toHexARGB(this.draftRingColor), x + 64 + 6, y + 4, 0xFFFFFF);
                }
                if (this.wHoverPick == null) break;
                x = this.wHoverPick.m_252754_() + this.wHoverPick.m_5711_() + 8;
                y = this.wHoverPick.m_252907_();
                this.drawColorPreview(g, x, y, this.draftHoverColor);
                g.m_280488_(this.f_96547_, ColorUtil.toHexARGB(this.draftHoverColor), x + 64 + 6, y + 4, 0xFFFFFF);
            }
        }
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    private void drawRightLabel(GuiGraphics g, EditBox eb, String label) {
        if (eb == null) {
            return;
        }
        int GAP = 8;
        int lx = eb.m_252754_() + eb.m_5711_() + 8;
        int ly = eb.m_252907_() + 4;
        g.m_280488_(this.f_96547_, label, lx, ly, 0xA0A0A0);
    }

    private void drawColorPreview(GuiGraphics g, int x, int y, int argb) {
        int sw = 64;
        int sh = 18;
        int cell = 6;
        for (int yy = 0; yy < sh; yy += cell) {
            for (int xx = 0; xx < sw; xx += cell) {
                int c = (xx / cell + yy / cell) % 2 == 0 ? -3355444 : -1;
                g.m_280509_(x + xx, y, x + Math.min(xx + cell, sw), y + Math.min(sh, cell), c);
            }
        }
        g.m_280509_(x, y, x + sw, y + sh, argb);
        g.m_280509_(x, y, x + sw, y + 1, -16777216);
        g.m_280509_(x, y + sh - 1, x + sw, y + sh, -16777216);
        g.m_280509_(x, y, x + 1, y + sh, -16777216);
        g.m_280509_(x + sw - 1, y, x + sw, y + sh, -16777216);
    }

    private static int parseSafeInt(EditBox eb, int dflt) {
        try {
            return Integer.parseInt(eb.m_94155_().trim());
        }
        catch (Throwable ignored) {
            return dflt;
        }
    }

    private static double parseSafeDouble(EditBox eb, double dflt) {
        try {
            return Double.parseDouble(eb.m_94155_().trim());
        }
        catch (Throwable ignored) {
            return dflt;
        }
    }

    private static int clamp(int v, int lo, int hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    private static double clampDouble(double v, double lo, double hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    private static enum Section {
        GENERAL,
        ANIM,
        DESIGN;

    }
}

