/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui.editor.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.data.menu.MenuItem;
import org.z2six.ezactions.data.menu.RadialMenu;

public final class MenuNavUtil {
    private MenuNavUtil() {
    }

    public static List<String> capturePathTitles() {
        try {
            List<String> parts = RadialMenu.pathTitles();
            if (parts == null) {
                return List.of();
            }
            return new ArrayList<String>(parts);
        }
        catch (Throwable t) {
            Constants.LOG.debug("[{}] capturePathTitles failed: {}", (Object)"ezactions", (Object)t.toString());
            return List.of();
        }
    }

    public static void goToRoot() {
        int guards = 256;
        while (RadialMenu.canGoBack() && guards-- > 0) {
            RadialMenu.goBack();
        }
    }

    public static void restorePathTitles(List<String> titles) {
        try {
            MenuNavUtil.goToRoot();
            if (titles == null || titles.isEmpty()) {
                return;
            }
            for (String title : titles) {
                if (title == null || title.isEmpty()) continue;
                List<MenuItem> level = RadialMenu.currentItems();
                if (level != null) {
                    MenuItem next = null;
                    for (MenuItem mi : level) {
                        String t;
                        if (mi == null || !mi.isCategory() || (t = mi.title()) == null || !Objects.equals(t, title)) continue;
                        next = mi;
                        break;
                    }
                    if (next != null) {
                        RadialMenu.enterCategory(next);
                        continue;
                    }
                }
                break;
            }
        }
        catch (Throwable t) {
            Constants.LOG.debug("[{}] restorePathTitles failed: {}", (Object)"ezactions", (Object)t.toString());
        }
    }
}

