/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui.overlay;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.data.icon.IconSpec;
import org.z2six.ezactions.gui.IconRenderer;

public final class RadialLingerOverlay {
    private static final List<Job> JOBS = new ArrayList<Job>();

    private RadialLingerOverlay() {
    }

    public static void add(IconSpec icon, int screenX, int screenY, int durationMs) {
        try {
            if (icon == null || durationMs <= 0) {
                return;
            }
            JOBS.add(new Job(icon, screenX, screenY, durationMs));
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Linger add failed: {}", (Object)"ezactions", (Object)t.toString());
        }
    }

    public static void render(GuiGraphics g) {
        if (JOBS.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        Iterator<Job> it = JOBS.iterator();
        while (it.hasNext()) {
            Job j = it.next();
            double t = (double)(now - j.startMs) / (double)j.durationMs;
            if (t >= 1.0) {
                it.remove();
                continue;
            }
            try {
                IconRenderer.drawIcon(g, j.x, j.y, j.icon);
                int alpha = (int)(t * 150.0);
                int aargb = alpha << 24;
                g.m_280509_(j.x - 12, j.y - 12, j.x + 12, j.y + 12, aargb);
            }
            catch (Throwable ex) {
                Constants.LOG.warn("[{}] Linger render error: {}", (Object)"ezactions", (Object)ex.toString());
            }
        }
    }

    public static void clear() {
        JOBS.clear();
    }

    private static final class Job {
        final IconSpec icon;
        final int x;
        final int y;
        final long startMs;
        final int durationMs;

        Job(IconSpec icon, int x, int y, int durationMs) {
            this.icon = icon;
            this.x = x;
            this.y = y;
            this.startMs = System.currentTimeMillis();
            this.durationMs = Math.max(0, durationMs);
        }
    }
}

