/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.helper;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.Nullable;
import org.z2six.ezactions.Constants;

public final class KeyboardHandlerHelper {
    private static final Deque<TapRequest> QUEUED_TAPS = new ArrayDeque<TapRequest>();
    private static final Deque<KeyMapping> HELD_THIS_TICK = new ArrayDeque<KeyMapping>();

    private KeyboardHandlerHelper() {
    }

    public static void enqueueTap(KeyMapping mapping) {
        if (mapping == null) {
            Constants.LOG.warn("[{}] enqueueTap called with null mapping; skipping.", (Object)"ezactions");
            return;
        }
        QUEUED_TAPS.addLast(new TapRequest(mapping));
        Constants.LOG.debug("[{}] Enqueued tick-tap for mapping '{}'.", (Object)"ezactions", (Object)mapping.m_90860_());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onClientTick() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91073_ == null) {
            if (!QUEUED_TAPS.isEmpty() || !HELD_THIS_TICK.isEmpty()) {
                Constants.LOG.debug("[{}] Clearing tap queues (no level). queued={}, held={}", new Object[]{"ezactions", QUEUED_TAPS.size(), HELD_THIS_TICK.size()});
            }
            QUEUED_TAPS.clear();
            KeyboardHandlerHelper.releaseHeldKeys();
            return;
        }
        KeyboardHandlerHelper.releaseHeldKeys();
        Iterator<TapRequest> it = QUEUED_TAPS.iterator();
        while (it.hasNext()) {
            TapRequest req = it.next();
            KeyMapping map = req.mapping;
            try {
                map.m_7249_(true);
                HELD_THIS_TICK.addLast(map);
                map.m_90859_();
                Constants.LOG.debug("[{}] Tick-press mapping '{}'", (Object)"ezactions", (Object)map.m_90860_());
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] Failed to tick-press mapping '{}': {}", new Object[]{"ezactions", map.m_90860_(), t.toString()});
            }
            finally {
                it.remove();
            }
        }
    }

    private static void releaseHeldKeys() {
        while (!HELD_THIS_TICK.isEmpty()) {
            KeyMapping m = HELD_THIS_TICK.pollFirst();
            try {
                m.m_7249_(false);
                Constants.LOG.debug("[{}] Released mapping '{}'", (Object)"ezactions", (Object)m.m_90860_());
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] Failed to release mapping '{}': {}", new Object[]{"ezactions", m.m_90860_(), t.toString()});
            }
        }
    }

    private record TapRequest(@Nullable KeyMapping mapping) {
    }
}

