/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.util;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.data.menu.MenuItem;
import org.z2six.ezactions.data.menu.RadialMenu;

public final class BundleHotkeyManager {
    private static final Map<String, KeyMapping> BUNDLE_KEYS_BY_ID = new HashMap<String, KeyMapping>();

    private BundleHotkeyManager() {
    }

    public static void registerBundleKeyMappings(RegisterKeyMappingsEvent e) {
        BUNDLE_KEYS_BY_ID.clear();
        try {
            RadialMenu.rootMutable();
            ArrayList<MenuItem> root = new ArrayList<MenuItem>(RadialMenu.rootMutable());
            HashSet<String> usedIds = new HashSet<String>();
            ArrayList<MenuItem> bundles = new ArrayList<MenuItem>();
            BundleHotkeyManager.collectBundles(root, bundles, usedIds);
            if (bundles.isEmpty()) {
                Constants.LOG.debug("[{}] BundleHotkeyManager: no bundles with keybinds enabled.", (Object)"ezactions");
                return;
            }
            for (MenuItem bundle : bundles) {
                String id = bundle.id();
                if (id == null || id.isBlank()) continue;
                String cleanId = BundleHotkeyManager.sanitizeBundleId(id);
                String keyName = "key.ezactions.bundle." + cleanId;
                String category = "key.categories.ezactions.bundles";
                KeyMapping mapping = new KeyMapping(keyName, InputConstants.f_84822_.m_84873_(), category);
                e.register(mapping);
                BUNDLE_KEYS_BY_ID.put(id, mapping);
                Constants.LOG.debug("[{}] Registered bundle keybind: id='{}', keyName='{}', category='{}'", new Object[]{"ezactions", id, keyName, category});
            }
            Constants.LOG.info("[{}] BundleHotkeyManager: registered {} bundle keybind(s).", (Object)"ezactions", (Object)BUNDLE_KEYS_BY_ID.size());
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] BundleHotkeyManager.registerBundleKeyMappings failed: {}", (Object)"ezactions", (Object)t.toString());
            BUNDLE_KEYS_BY_ID.clear();
        }
    }

    public static Map<String, KeyMapping> getBundleKeyMappings() {
        return BUNDLE_KEYS_BY_ID;
    }

    private static void collectBundles(List<MenuItem> src, List<MenuItem> out, Set<String> usedIds) {
        if (src == null) {
            return;
        }
        for (MenuItem mi : src) {
            if (mi == null) continue;
            try {
                String id;
                if (!mi.isCategory()) continue;
                if (mi.bundleKeybindEnabled() && (id = mi.id()) != null && !id.isBlank() && usedIds.add(id)) {
                    out.add(mi);
                }
                BundleHotkeyManager.collectBundles(mi.childrenMutable(), out, usedIds);
            }
            catch (Throwable t) {
                Constants.LOG.debug("[{}] collectBundles skipped entry due to error: {}", (Object)"ezactions", (Object)t.toString());
            }
        }
    }

    private static String sanitizeBundleId(String id) {
        String lower = id.toLowerCase(Locale.ROOT).trim();
        if (lower.isEmpty()) {
            return "unnamed";
        }
        return lower.replaceAll("[^a-z0-9_.-]", "_");
    }
}

