/*
 * Decompiled with CFR 0.152.
 */
package sp;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class SPConfig {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("smart_particles/config.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static SPConfig instance = new SPConfig();
    public int particleLimit = 5000;
    public boolean smartCameraCulling = true;

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                instance = (SPConfig)GSON.fromJson(json, SPConfig.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            SPConfig.save();
        }
        if (SPConfig.instance.particleLimit < 0) {
            SPConfig.instance.particleLimit = 0;
            SPConfig.save();
        }
    }

    public static void save() {
        try {
            if (!Files.exists(CONFIG_PATH.getParent(), new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            }
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)instance), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

