/*
 * Decompiled with CFR 0.152.
 */
package sp.mixin;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3999;
import net.minecraft.class_5878;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sp.SPConfig;
import sp.mixin.SPAccessor;

@Mixin(value={class_702.class})
public abstract class ParticleManagerMixin {
    @Shadow
    private Map<class_3999, Queue<class_703>> field_3830;
    @Shadow
    private Object2IntOpenHashMap<class_5878> field_29072;

    @Inject(method={"method_3057"}, at={@At(value="TAIL")})
    private void smartparticles$enforceParticleLimit(CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        int limit = Math.max(0, SPConfig.instance.particleLimit);
        boolean smartCulling = SPConfig.instance.smartCameraCulling;
        if (!smartCulling) {
            int total = 0;
            for (Queue<class_703> q : this.field_3830.values()) {
                total += q.size();
            }
            if (total <= limit) {
                return;
            }
        }
        class_243 camPos = player.method_33571();
        class_243 camDir = player.method_5828(1.0f);
        double fov = ((Integer)client.field_1690.method_41808().method_41753()).intValue();
        double frustumThreshold = Math.cos(Math.toRadians(fov / 2.0 + 30.0));
        double frustumPenalty = 1.0E10;
        double px = player.method_23317();
        double py = player.method_23318();
        double pz = player.method_23321();
        class_703[] heapParticles = new class_703[limit];
        double[] heapScores = new double[limit];
        int heapSize = 0;
        for (Queue<class_703> q : this.field_3830.values()) {
            for (class_703 p : q) {
                double distSq;
                double eDistSq;
                SPAccessor acc = (SPAccessor)p;
                double ex = acc.smartparticles$getX() - camPos.field_1352;
                double ey = acc.smartparticles$getY() - camPos.field_1351;
                double ez = acc.smartparticles$getZ() - camPos.field_1350;
                double dot = ex * camDir.field_1352 + ey * camDir.field_1351 + ez * camDir.field_1350;
                boolean inFrustum = false;
                if (dot > 0.0 && dot * dot > frustumThreshold * frustumThreshold * (eDistSq = ex * ex + ey * ey + ez * ez)) {
                    inFrustum = true;
                }
                if (smartCulling && !inFrustum) continue;
                double dx = acc.smartparticles$getX() - px;
                double dy = acc.smartparticles$getY() - py;
                double dz = acc.smartparticles$getZ() - pz;
                double score = distSq = dx * dx + dy * dy + dz * dz;
                if (!smartCulling && !inFrustum) {
                    score += frustumPenalty;
                }
                if (heapSize < limit) {
                    heapParticles[heapSize] = p;
                    heapScores[heapSize] = score;
                    ParticleManagerMixin.heapSiftUp(heapParticles, heapScores, heapSize);
                    ++heapSize;
                    continue;
                }
                if (!(score < heapScores[0])) continue;
                heapParticles[0] = p;
                heapScores[0] = score;
                ParticleManagerMixin.heapSiftDown(heapParticles, heapScores, heapSize, 0);
            }
        }
        Set keep = Collections.newSetFromMap(new IdentityHashMap());
        for (int i = 0; i < heapSize; ++i) {
            keep.add(heapParticles[i]);
        }
        for (Queue<class_703> q : this.field_3830.values()) {
            Iterator it = q.iterator();
            while (it.hasNext()) {
                class_703 p = (class_703)it.next();
                if (keep.contains(p)) continue;
                it.remove();
                p.method_3085();
                this.decrementGroupCount(p);
            }
        }
    }

    private void decrementGroupCount(class_703 p) {
        p.method_34019().ifPresent(group -> {
            int current = this.field_29072.getInt(group);
            if (current <= 1) {
                this.field_29072.removeInt(group);
            } else {
                this.field_29072.put(group, current - 1);
            }
        });
    }

    private static void heapSiftUp(class_703[] ps, double[] ds, int idx) {
        while (idx > 0) {
            int parent = idx - 1 >>> 1;
            if (ds[parent] >= ds[idx]) {
                return;
            }
            ParticleManagerMixin.swap(ps, ds, parent, idx);
            idx = parent;
        }
    }

    private static void heapSiftDown(class_703[] ps, double[] ds, int size, int idx) {
        int left;
        while ((left = (idx << 1) + 1) < size) {
            int right = left + 1;
            int largest = left;
            if (right < size && ds[right] > ds[left]) {
                largest = right;
            }
            if (ds[idx] >= ds[largest]) {
                return;
            }
            ParticleManagerMixin.swap(ps, ds, idx, largest);
            idx = largest;
        }
        return;
    }

    private static void swap(class_703[] ps, double[] ds, int a, int b) {
        class_703 tp = ps[a];
        ps[a] = ps[b];
        ps[b] = tp;
        double td = ds[a];
        ds[a] = ds[b];
        ds[b] = td;
    }
}

