/*
 * Decompiled with CFR 0.152.
 */
package me.imbanana.selfiecam;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import java.io.File;
import java.io.IOException;
import me.imbanana.selfiecam.SelfiecamClient;
import me.imbanana.selfiecam.mixin.CameraAccessor;
import net.minecraft.class_1011;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_9779;
import org.joml.Vector2i;

public class ModCamera {
    public static final float MIN_CAMERA_ANGLE = -90.0f;
    public static final float MAX_CAMERA_ANGLE = 35.0f;
    private final double MAX_ZOOM = 1.3;
    private final double MIN_ZOOM = 0.8;
    public static final double DEFAULT_ZOOM = 0.5;
    private boolean isInSelfieMode = false;
    private boolean shouldHideGUI = false;
    private double zoomPercentage = 0.5;

    public void setInSelfieMode(boolean value) {
        this.isInSelfieMode = value;
    }

    public boolean isInSelfieMode() {
        return this.isInSelfieMode;
    }

    public void setZoomPercentage(double value) {
        this.zoomPercentage = value;
    }

    public double getZoomPercentage() {
        return this.zoomPercentage;
    }

    public boolean shouldHideGUI() {
        return this.shouldHideGUI;
    }

    public void handleCamera(CameraAccessor camera) {
        float xRot = camera.selfieCam$getXRot();
        float yRot = camera.selfieCam$getYRot();
        float finalYRot = yRot + 180.0f;
        float finalXRot = -Math.clamp(xRot, -90.0f, 35.0f);
        camera.selfieCam$setRotation(finalYRot, finalXRot);
        camera.selfieCam$move(-camera.selfieCam$getMaxZoom((float)this.calcZoom(this.zoomPercentage)), 0.0f, 0.0f);
    }

    public void handleMouseScroll(Vector2i scroll) {
        float zoomAmount = (float)(-scroll.y) / 10.0f;
        this.zoomPercentage = Math.clamp(this.zoomPercentage + (double)zoomAmount, 0.0, 1.0);
    }

    private double calcZoom(double percentage) {
        float fov = ((Integer)class_310.method_1551().field_1690.method_41808().method_41753()).intValue();
        double maxZoom = 1.3 - (double)(fov / 90.0f) * 0.1;
        return 0.8 + (maxZoom - 0.8) * percentage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takePic(int width, int height) {
        class_310 minecraft = class_310.method_1551();
        class_276 renderTarget = minecraft.method_1522();
        int startX = (renderTarget.field_1482 - width) / 2;
        int startY = (renderTarget.field_1481 - height) / 2;
        try {
            this.shouldHideGUI = true;
            minecraft.field_1773.method_3192(class_9779.field_51956, true);
            GpuTexture gpuTexture = renderTarget.method_30277();
            if (gpuTexture == null) {
                throw new IllegalStateException("Tried to capture screenshot of an incomplete framebuffer");
            }
            GpuBuffer gpuBuffer = RenderSystem.getDevice().createBuffer(() -> "Picture Buffer", 9, (long)(renderTarget.field_1482 * renderTarget.field_1481 * gpuTexture.getFormat().pixelSize()));
            CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
            RenderSystem.getDevice().createCommandEncoder().copyTextureToBuffer(gpuTexture, gpuBuffer, 0L, () -> {
                try (GpuBuffer.MappedView mappedView = commandEncoder.mapBuffer(gpuBuffer, true, false);){
                    class_1011 nativeImage = new class_1011(width, height, false);
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            int color = mappedView.data().getInt((startX + x + (startY + y) * renderTarget.field_1482) * gpuTexture.getFormat().pixelSize());
                            nativeImage.method_4305(x, height - y - 1, color | 0xFF000000);
                        }
                    }
                    File picDir = new File(minecraft.field_1697, "pictures");
                    picDir.mkdir();
                    File picFile = ModCamera.getFile(picDir);
                    class_156.method_27958().execute(() -> {
                        try {
                            nativeImage.method_4325(picFile);
                            minecraft.execute(() -> minecraft.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)picFile.getName()).method_27692(class_124.field_1073).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10607(picFile.getAbsoluteFile())))));
                        }
                        catch (IOException e) {
                            SelfiecamClient.LOGGER.error("Couldn't save the picture", (Throwable)e);
                        }
                        nativeImage.close();
                    });
                }
                gpuBuffer.close();
            }, 0);
        }
        catch (Exception e) {
            SelfiecamClient.LOGGER.error("Couldn't save the picture", (Throwable)e);
        }
        finally {
            this.shouldHideGUI = false;
        }
    }

    private static File getFile(File file) {
        String string = class_156.method_44893();
        int i = 1;
        File file2;
        while ((file2 = new File(file, string + (String)(i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file2;
    }
}

