/*
 * Decompiled with CFR 0.152.
 */
package me.imbanana.selfiecam.gui;

import java.util.ArrayList;
import java.util.List;
import me.imbanana.selfiecam.SelfiecamClient;
import me.imbanana.selfiecam.gui.CapturePictureButton;
import me.imbanana.selfiecam.gui.FilterSelectionWidget;
import me.imbanana.selfiecam.gui.FilterToggleButton;
import me.imbanana.selfiecam.gui.RatioSelectionWidget;
import me.imbanana.selfiecam.gui.ZoomSliderWidget;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_433;
import net.minecraft.class_5289;
import net.minecraft.class_9779;
import org.jetbrains.annotations.NotNull;

public class CameraControlsScreen
extends class_362 {
    private boolean isEnabled = false;
    private final List<class_364> widgets = new ArrayList<class_364>();
    private final List<class_4068> renderables = new ArrayList<class_4068>();
    private int width;
    private int height;
    private double oldZoomValueSlider;
    private ZoomSliderWidget sliderWidget;
    private CapturePictureButton capturePictureButton;
    private FilterToggleButton filterToggleButton;
    private FilterSelectionWidget filterSelectionWidget;
    private RatioSelectionWidget ratioSelectionWidget;

    public void showOverlay() {
        this.isEnabled = true;
        this.init();
    }

    public void hideOverlay() {
        this.isEnabled = false;
    }

    public boolean isEnabled() {
        return this.isEnabled && !class_310.method_1551().field_1690.field_1842 && !(class_310.method_1551().field_1755 instanceof class_5289) && !(class_310.method_1551().field_1755 instanceof class_433);
    }

    private void init() {
        this.width = class_310.method_1551().method_22683().method_4486();
        this.height = class_310.method_1551().method_22683().method_4502();
        this.oldZoomValueSlider = 0.5;
        this.buildWidgets();
    }

    private void buildWidgets() {
        this.widgets.clear();
        this.renderables.clear();
        this.sliderWidget = new ZoomSliderWidget((this.width - 200) / 2, this.height - 30, 200, 20, (class_2561)class_2561.method_43473(), (class_2561)class_2561.method_43473(), 100.0, 0.0, SelfiecamClient.getCameraController().getZoomPercentage() * 100.0, 0.0, 2, true);
        this.capturePictureButton = new CapturePictureButton(this.width - 42, this.height - 42, 32, 32, this.width, this.height);
        this.filterToggleButton = new FilterToggleButton(this.width - 42, this.height - 184, 32, 32, false);
        this.filterSelectionWidget = new FilterSelectionWidget(this.width - 80, this.height - 152, 80, 100);
        this.ratioSelectionWidget = new RatioSelectionWidget(this.width / 2, this.height / 2, this.width, this.height);
        this.addRenderable((class_4068)this.ratioSelectionWidget);
        this.addRenderableWidget(this.sliderWidget);
        this.addRenderableWidget(this.capturePictureButton);
        this.addRenderableWidget(this.filterToggleButton);
        this.addRenderableWidget(this.filterSelectionWidget);
        this.addWidget((class_364)this.ratioSelectionWidget);
    }

    public void tick() {
        if (this.oldZoomValueSlider != this.sliderWidget.getValue()) {
            SelfiecamClient.getCameraController().setZoomPercentage(this.sliderWidget.getValue() / 100.0);
        } else {
            this.sliderWidget.method_25347(SelfiecamClient.getCameraController().getZoomPercentage() * 100.0);
        }
        this.oldZoomValueSlider = this.sliderWidget.getValue();
        this.capturePictureButton.setCaptureWidth(this.ratioSelectionWidget.getFrameBufferWidth());
        this.capturePictureButton.setCaptureHeight(this.ratioSelectionWidget.getFrameBufferHeight());
        if (this.filterToggleButton.isOpen()) {
            this.filterSelectionWidget.show();
        } else {
            this.filterSelectionWidget.hide();
        }
    }

    public void render(class_332 guiGraphics, class_9779 deltaTracker) {
        guiGraphics.method_71048();
        int xPos = (int)class_310.method_1551().field_1729.method_68879(class_310.method_1551().method_22683());
        int yPos = (int)class_310.method_1551().field_1729.method_68883(class_310.method_1551().method_22683());
        this.renderables.forEach(renderable -> renderable.method_25394(guiGraphics, xPos, yPos, deltaTracker.method_60637(false)));
        guiGraphics.method_73199();
    }

    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
        this.buildWidgets();
    }

    private <T extends class_364 & class_4068> void addRenderableWidget(T widget) {
        this.renderables.add(widget);
        this.widgets.add(widget);
    }

    private void addWidget(class_364 widget) {
        this.widgets.add(widget);
    }

    private void addRenderable(class_4068 renderable) {
        this.renderables.add(renderable);
    }

    public boolean method_25402(class_11909 mouseButtonEvent, boolean bl) {
        if (super.method_25402(mouseButtonEvent, bl)) {
            return true;
        }
        if (this.ratioSelectionWidget.method_25402(mouseButtonEvent, bl)) {
            this.method_25395((class_364)this.ratioSelectionWidget);
            if (mouseButtonEvent.method_74245() == 0) {
                this.method_25398(true);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public List<? extends class_364> method_25396() {
        return this.widgets;
    }

    public boolean canInteract() {
        return !class_310.method_1551().field_1729.method_1613();
    }
}

