/*
 * Decompiled with CFR 0.152.
 */
package me.imbanana.selfiecam.gui;

import java.text.DecimalFormat;
import java.util.Objects;
import me.imbanana.selfiecam.SelfiecamClient;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_5250;
import net.minecraft.class_9848;

public class ZoomSliderWidget
extends class_357 {
    protected class_2561 prefix;
    protected class_2561 suffix;
    protected double minValue;
    protected double maxValue;
    protected double stepSize;
    protected boolean drawString;
    private final DecimalFormat format;

    public ZoomSliderWidget(int x, int y, int width, int height, class_2561 prefix, class_2561 suffix, double minValue, double maxValue, double currentValue, double stepSize, int precision, boolean drawString) {
        super(x, y, width, height, (class_2561)class_2561.method_43473(), 0.0);
        this.prefix = prefix;
        this.suffix = suffix;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = Math.abs(stepSize);
        this.field_22753 = this.snapToNearest((currentValue - minValue) / (maxValue - minValue));
        this.drawString = drawString;
        if (stepSize == 0.0) {
            precision = Math.min(precision, 4);
            StringBuilder builder = new StringBuilder("0");
            if (precision > 0) {
                builder.append('.');
            }
            while (precision-- > 0) {
                builder.append('0');
            }
            this.format = new DecimalFormat(builder.toString());
        } else {
            this.format = class_3532.method_20390((double)this.stepSize, (double)Math.floor(this.stepSize)) ? new DecimalFormat("0") : new DecimalFormat(Double.toString(this.stepSize).replaceAll("\\d", "0"));
        }
        this.method_25346();
    }

    public ZoomSliderWidget(int x, int y, int width, int height, class_2561 prefix, class_2561 suffix, double minValue, double maxValue, double currentValue, boolean drawString) {
        this(x, y, width, height, prefix, suffix, minValue, maxValue, currentValue, 1.0, 0, drawString);
    }

    public double getValue() {
        return this.field_22753 * (this.maxValue - this.minValue) + this.minValue;
    }

    public long getValueLong() {
        return Math.round(this.getValue());
    }

    public int getValueInt() {
        return (int)this.getValueLong();
    }

    public void method_25347(double value) {
        this.setFractionalValue((value - this.minValue) / (this.maxValue - this.minValue));
    }

    public String getValueString() {
        return this.format.format(this.getValue());
    }

    public void method_25348(class_11909 event, boolean doubleClick) {
        this.setValueFromMouse(event.comp_4798());
    }

    protected void method_25349(class_11909 event, double dragX, double dragY) {
        super.method_25349(event, dragX, dragY);
        this.setValueFromMouse(event.comp_4798());
    }

    public boolean method_25404(class_11908 keyEvent) {
        boolean flag = keyEvent.method_74232();
        if (flag || keyEvent.method_74233()) {
            float f;
            if (this.minValue > this.maxValue) {
                flag = !flag;
            }
            float f2 = f = flag ? -1.0f : 1.0f;
            if (this.stepSize <= 0.0) {
                this.setFractionalValue(this.field_22753 + (double)(f / (float)(this.field_22758 - 8)));
            } else {
                this.method_25347(this.getValue() + (double)f * this.stepSize);
            }
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setFractionalValue((mouseX - (double)(this.method_46426() + 4)) / (double)(this.field_22758 - 8));
    }

    private void setFractionalValue(double fractionalValue) {
        double oldValue = this.field_22753;
        this.field_22753 = this.snapToNearest(fractionalValue);
        if (!class_3532.method_20390((double)oldValue, (double)this.field_22753)) {
            this.method_25344();
        }
        this.method_25346();
    }

    private double snapToNearest(double value) {
        if (this.stepSize <= 0.0) {
            return class_3532.method_15350((double)value, (double)0.0, (double)1.0);
        }
        value = class_3532.method_16436((double)class_3532.method_15350((double)value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue);
        value = this.stepSize * (double)Math.round(value / this.stepSize);
        value = this.minValue > this.maxValue ? class_3532.method_15350((double)value, (double)this.maxValue, (double)this.minValue) : class_3532.method_15350((double)value, (double)this.minValue, (double)this.maxValue);
        return class_3532.method_33722((double)value, (double)this.minValue, (double)this.maxValue, (double)0.0, (double)1.0);
    }

    protected void method_25346() {
        if (this.drawString) {
            this.method_25355((class_2561)class_2561.method_43470((String)"").method_10852(this.prefix).method_27693(this.getValueString()).method_10852(this.suffix));
        } else {
            this.method_25355((class_2561)class_2561.method_43473());
        }
    }

    protected void method_25344() {
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_310 minecraft = class_310.method_1551();
        class_327 class_3272 = minecraft.field_1772;
        class_5250 class_52502 = class_2561.method_43471((String)"gui.selfiecam.camera.zoom");
        int n = this.method_46426() + this.method_25368() / 2;
        int n2 = this.method_46427();
        Objects.requireNonNull(minecraft.field_1772);
        guiGraphics.method_27534(class_3272, (class_2561)class_52502, n, n2 - 9, -1);
        class_327 class_3273 = minecraft.field_1772;
        int n3 = this.method_46426() - minecraft.field_1772.method_1727("+") - 5;
        double d = this.method_46427();
        Objects.requireNonNull(minecraft.field_1772);
        guiGraphics.method_25303(class_3273, "+", n3, (int)(d + 9.0 / 1.5), -1);
        class_327 class_3274 = minecraft.field_1772;
        int n4 = this.method_46426() + this.method_25368() + 5;
        double d2 = this.method_46427();
        Objects.requireNonNull(minecraft.field_1772);
        guiGraphics.method_25303(class_3274, "-", n4, (int)(d2 + 9.0 / 1.5), -1);
        class_2960 sprite = this.method_37303() && this.method_25370() && !this.field_41796 ? SelfiecamClient.idOf("widget/slider") : SelfiecamClient.idOf("widget/slider_highlight");
        class_2960 handleSprite = !this.method_37303() || !this.field_22762 && !this.field_41796 ? SelfiecamClient.idOf("widget/slider_handle") : SelfiecamClient.idOf("widget/slider_handle_highlight");
        guiGraphics.method_52707(class_10799.field_56883, sprite, this.method_46426(), this.method_46427() + this.method_25364() / 4, this.method_25368(), this.method_25364() / 2, class_9848.method_61317((float)this.field_22765));
        guiGraphics.method_52707(class_10799.field_56883, handleSprite, this.method_46426() + (int)(this.field_22753 * (double)(this.field_22758 - 8)), this.method_46427(), 8, this.method_25364(), class_9848.method_61317((float)this.field_22765));
        int i = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
        this.method_75799(guiGraphics.method_75787((class_339)this, class_332.class_12228.field_63850), (class_2561)this.field_22754.method_27661().method_54663(i), 2);
    }
}

