/*
 * Decompiled with CFR 0.152.
 */
package me.imbanana.selfiecam;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import java.io.File;
import java.io.IOException;
import me.imbanana.selfiecam.SelfiecamClient;
import me.imbanana.selfiecam.mixin.CameraAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import org.joml.Vector2i;

public class ModCamera {
    public static final float MIN_CAMERA_ANGLE = -90.0f;
    public static final float MAX_CAMERA_ANGLE = 35.0f;
    private final double MAX_ZOOM = 1.3;
    private final double MIN_ZOOM = 0.8;
    public static final double DEFAULT_ZOOM = 0.5;
    private boolean isInSelfieMode = false;
    private boolean shouldHideGUI = false;
    private double zoomPercentage = 0.5;

    public void setInSelfieMode(boolean value) {
        this.isInSelfieMode = value;
    }

    public boolean isInSelfieMode() {
        return this.isInSelfieMode;
    }

    public void setZoomPercentage(double value) {
        this.zoomPercentage = value;
    }

    public double getZoomPercentage() {
        return this.zoomPercentage;
    }

    public boolean shouldHideGUI() {
        return this.shouldHideGUI;
    }

    public void handleCamera(CameraAccessor camera) {
        float xRot = camera.selfieCam$getXRot();
        float yRot = camera.selfieCam$getYRot();
        float finalYRot = yRot + 180.0f;
        float finalXRot = -Math.clamp(xRot, -90.0f, 35.0f);
        camera.selfieCam$setRotation(finalYRot, finalXRot);
        camera.selfieCam$move(-camera.selfieCam$getMaxZoom((float)this.calcZoom(this.zoomPercentage)), 0.0f, 0.0f);
    }

    public void handleMouseScroll(Vector2i scroll) {
        float zoomAmount = (float)(-scroll.y) / 10.0f;
        this.zoomPercentage = Math.clamp(this.zoomPercentage + (double)zoomAmount, 0.0, 1.0);
    }

    private double calcZoom(double percentage) {
        float fov = ((Integer)Minecraft.getInstance().options.fov().get()).intValue();
        double maxZoom = 1.3 - (double)(fov / 90.0f) * 0.1;
        return 0.8 + (maxZoom - 0.8) * percentage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takePic(int width, int height) {
        Minecraft minecraft = Minecraft.getInstance();
        RenderTarget renderTarget = minecraft.getMainRenderTarget();
        int startX = (renderTarget.width - width) / 2;
        int startY = (renderTarget.height - height) / 2;
        try {
            this.shouldHideGUI = true;
            minecraft.gameRenderer.render(DeltaTracker.ONE, true);
            GpuTexture gpuTexture = renderTarget.getColorTexture();
            if (gpuTexture == null) {
                throw new IllegalStateException("Tried to capture screenshot of an incomplete framebuffer");
            }
            GpuBuffer gpuBuffer = RenderSystem.getDevice().createBuffer(() -> "Picture Buffer", 9, renderTarget.width * renderTarget.height * gpuTexture.getFormat().pixelSize());
            CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
            RenderSystem.getDevice().createCommandEncoder().copyTextureToBuffer(gpuTexture, gpuBuffer, 0, () -> {
                try (GpuBuffer.MappedView mappedView = commandEncoder.mapBuffer(gpuBuffer, true, false);){
                    NativeImage nativeImage = new NativeImage(width, height, false);
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            int color = mappedView.data().getInt((startX + x + (startY + y) * renderTarget.width) * gpuTexture.getFormat().pixelSize());
                            nativeImage.setPixelABGR(x, height - y - 1, color | 0xFF000000);
                        }
                    }
                    File picDir = new File(minecraft.gameDirectory, "pictures");
                    picDir.mkdir();
                    File picFile = ModCamera.getFile(picDir);
                    Util.ioPool().execute(() -> {
                        try {
                            nativeImage.writeToFile(picFile);
                            minecraft.execute(() -> minecraft.gui.getChat().addMessage((Component)Component.literal((String)picFile.getName()).withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.OpenFile(picFile.getAbsoluteFile())))));
                        }
                        catch (IOException e) {
                            SelfiecamClient.LOGGER.error("Couldn't save the picture", (Throwable)e);
                        }
                        nativeImage.close();
                    });
                }
                gpuBuffer.close();
            }, 0);
        }
        catch (Exception e) {
            SelfiecamClient.LOGGER.error("Couldn't save the picture", (Throwable)e);
        }
        finally {
            this.shouldHideGUI = false;
        }
    }

    private static File getFile(File file) {
        String string = Util.getFilenameFormattedDateTime();
        int i = 1;
        File file2;
        while ((file2 = new File(file, string + (String)(i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file2;
    }
}

