/*
 * Decompiled with CFR 0.152.
 */
package me.imbanana.selfiecam;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.joml.Quaternionfc;

public class ModPlayerController {
    private HumanoidArm selfieArm = null;

    public void setSelfieArm(HumanoidArm selfieArm) {
        this.selfieArm = selfieArm;
    }

    public HumanoidArm getSelfieArm() {
        return this.selfieArm;
    }

    public <S extends ArmedEntityRenderState, M extends EntityModel<S> & HeadedModel> boolean renderSelfieStick(S avatarRenderState, PoseStack poseStack, ItemStackRenderState itemStackRenderState, HumanoidArm humanoidArm, SubmitNodeCollector submitNodeCollector, int i, M parentModel) {
        if (humanoidArm != this.selfieArm) {
            return false;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        ItemModelResolver itemModelResolver = Minecraft.getInstance().getItemModelResolver();
        ItemDisplayContext itemDisplayContext = this.selfieArm == HumanoidArm.RIGHT ? ItemDisplayContext.THIRD_PERSON_RIGHT_HAND : ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
        poseStack.pushPose();
        itemStackRenderState.clear();
        itemModelResolver.updateForTopItem(itemStackRenderState, new ItemStack((ItemLike)Items.STICK, 1), itemDisplayContext, player.level(), (ItemOwner)player, player.getId() + itemDisplayContext.ordinal());
        ((ArmedModel)parentModel).translateToHand(avatarRenderState, humanoidArm, poseStack);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-20.0f));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        poseStack.translate((double)((float)(humanoidArm == HumanoidArm.LEFT ? -1 : 1) / 16.0f), (double)0.8f, -0.35);
        itemStackRenderState.submit(poseStack, submitNodeCollector, i, OverlayTexture.NO_OVERLAY, avatarRenderState.outlineColor);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(30.0f));
        poseStack.popPose();
        return true;
    }

    public void setupPlayerHand(ModelPart rightArm, ModelPart leftArm, ModelPart head) {
        head.xRot = (float)Math.clamp((double)head.xRot, Math.toRadians(-90.0), Math.toRadians(35.0));
        if (this.selfieArm == HumanoidArm.RIGHT) {
            rightArm.xRot = (float)((double)head.xRot - 1.5707963267948966 + (double)(head.xRot * -0.25f));
            rightArm.yRot = head.yRot;
            rightArm.zRot = head.xRot * 0.15f;
        } else if (this.selfieArm == HumanoidArm.LEFT) {
            leftArm.xRot = (float)((double)head.xRot - 1.5707963267948966 + (double)(head.xRot * -0.25f));
            leftArm.yRot = head.yRot;
            leftArm.zRot = head.xRot * -0.15f;
        }
    }
}

