/*
 * Decompiled with CFR 0.152.
 */
package me.imbanana.selfiecam.gui;

import java.util.ArrayList;
import java.util.List;
import me.imbanana.selfiecam.SelfiecamClient;
import me.imbanana.selfiecam.gui.CapturePictureButton;
import me.imbanana.selfiecam.gui.FilterSelectionWidget;
import me.imbanana.selfiecam.gui.FilterToggleButton;
import me.imbanana.selfiecam.gui.RatioSelectionWidget;
import me.imbanana.selfiecam.gui.ZoomSliderWidget;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.debug.GameModeSwitcherScreen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class CameraControlsScreen
extends AbstractContainerEventHandler {
    private boolean isEnabled = false;
    private final List<GuiEventListener> widgets = new ArrayList<GuiEventListener>();
    private final List<Renderable> renderables = new ArrayList<Renderable>();
    private int width;
    private int height;
    private double oldZoomValueSlider;
    private ZoomSliderWidget sliderWidget;
    private CapturePictureButton capturePictureButton;
    private FilterToggleButton filterToggleButton;
    private FilterSelectionWidget filterSelectionWidget;
    private RatioSelectionWidget ratioSelectionWidget;

    public void showOverlay() {
        this.isEnabled = true;
        this.init();
    }

    public void hideOverlay() {
        this.isEnabled = false;
    }

    public boolean isEnabled() {
        return this.isEnabled && !Minecraft.getInstance().options.hideGui && !(Minecraft.getInstance().screen instanceof GameModeSwitcherScreen) && !(Minecraft.getInstance().screen instanceof PauseScreen);
    }

    private void init() {
        this.width = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        this.height = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        this.oldZoomValueSlider = 0.5;
        this.buildWidgets();
    }

    private void buildWidgets() {
        this.widgets.clear();
        this.renderables.clear();
        this.sliderWidget = new ZoomSliderWidget((this.width - 200) / 2, this.height - 30, 200, 20, (Component)Component.empty(), (Component)Component.empty(), 100.0, 0.0, SelfiecamClient.getCameraController().getZoomPercentage() * 100.0, 0.0, 2, true);
        this.capturePictureButton = new CapturePictureButton(this.width - 42, this.height - 42, 32, 32, this.width, this.height);
        this.filterToggleButton = new FilterToggleButton(this.width - 42, this.height - 184, 32, 32, false);
        this.filterSelectionWidget = new FilterSelectionWidget(this.width - 80, this.height - 152, 80, 100);
        this.ratioSelectionWidget = new RatioSelectionWidget(this.width / 2, this.height / 2, this.width, this.height);
        this.addRenderable((Renderable)this.ratioSelectionWidget);
        this.addRenderableWidget(this.sliderWidget);
        this.addRenderableWidget(this.capturePictureButton);
        this.addRenderableWidget(this.filterToggleButton);
        this.addRenderableWidget(this.filterSelectionWidget);
        this.addWidget((GuiEventListener)this.ratioSelectionWidget);
    }

    public void tick() {
        if (this.oldZoomValueSlider != this.sliderWidget.getValue()) {
            SelfiecamClient.getCameraController().setZoomPercentage(this.sliderWidget.getValue() / 100.0);
        } else {
            this.sliderWidget.setValue(SelfiecamClient.getCameraController().getZoomPercentage() * 100.0);
        }
        this.oldZoomValueSlider = this.sliderWidget.getValue();
        this.capturePictureButton.setCaptureWidth(this.ratioSelectionWidget.getFrameBufferWidth());
        this.capturePictureButton.setCaptureHeight(this.ratioSelectionWidget.getFrameBufferHeight());
        if (this.filterToggleButton.isOpen()) {
            this.filterSelectionWidget.show();
        } else {
            this.filterSelectionWidget.hide();
        }
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        guiGraphics.nextStratum();
        int xPos = (int)Minecraft.getInstance().mouseHandler.getScaledXPos(Minecraft.getInstance().getWindow());
        int yPos = (int)Minecraft.getInstance().mouseHandler.getScaledYPos(Minecraft.getInstance().getWindow());
        this.renderables.forEach(renderable -> renderable.render(guiGraphics, xPos, yPos, deltaTracker.getGameTimeDeltaPartialTick(false)));
        guiGraphics.renderDeferredElements();
    }

    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
        this.buildWidgets();
    }

    private <T extends GuiEventListener & Renderable> void addRenderableWidget(T widget) {
        this.renderables.add(widget);
        this.widgets.add(widget);
    }

    private void addWidget(GuiEventListener widget) {
        this.widgets.add(widget);
    }

    private void addRenderable(Renderable renderable) {
        this.renderables.add(renderable);
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean bl) {
        if (super.mouseClicked(mouseButtonEvent, bl)) {
            return true;
        }
        if (this.ratioSelectionWidget.mouseClicked(mouseButtonEvent, bl)) {
            this.setFocused((GuiEventListener)this.ratioSelectionWidget);
            if (mouseButtonEvent.button() == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        return this.widgets;
    }

    public boolean canInteract() {
        return !Minecraft.getInstance().mouseHandler.isMouseGrabbed();
    }
}

