/*
 * Decompiled with CFR 0.152.
 */
package me.imbanana.selfiecam.gui;

import com.mojang.blaze3d.platform.cursor.CursorTypes;
import java.time.Duration;
import java.util.function.Supplier;
import me.imbanana.selfiecam.SelfiecamClient;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;

public class CapturePictureButton
extends Button {
    private int captureWidth;
    private int captureHeight;

    public CapturePictureButton(int x, int y, int width, int height, int captureWidth, int captureHeight) {
        super(x, y, width, height, (Component)Component.translatable((String)"gui.selfiecam.camera.capture"), button -> {}, Supplier::get);
        this.captureWidth = captureWidth;
        this.captureHeight = captureHeight;
        this.setTooltip(Tooltip.create((Component)this.getMessage()));
        this.setTooltipDelay(Duration.ofMillis(500L));
    }

    public void onPress(InputWithModifiers inputWithModifiers) {
        SelfiecamClient.getCameraController().takePic(this.captureWidth, this.captureHeight);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SelfiecamClient.idOf("widget/capture_button" + (this.isHoveredOrFocused() ? "_highlight" : "")), this.getX(), this.getY(), this.getWidth(), this.getHeight(), ARGB.white((float)this.alpha));
        if (this.isHovered()) {
            guiGraphics.requestCursor(this.isActive() ? CursorTypes.POINTING_HAND : CursorTypes.NOT_ALLOWED);
        }
    }

    public void setCaptureHeight(int captureHeight) {
        this.captureHeight = captureHeight;
    }

    public void setCaptureWidth(int captureWidth) {
        this.captureWidth = captureWidth;
    }
}

