/*
 * Decompiled with CFR 0.152.
 */
package me.imbanana.selfiecam.gui;

import com.mojang.blaze3d.platform.cursor.CursorTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.imbanana.selfiecam.ModShaders;
import me.imbanana.selfiecam.SelfiecamClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractContainerWidget;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.jetbrains.annotations.NotNull;

public class FilterSelectionWidget
extends AbstractContainerWidget {
    private final List<FilterEntry> entries = new ArrayList<FilterEntry>();

    public FilterSelectionWidget(int i, int j, int k, int l) {
        super(i, j, k, l, (Component)Component.literal((String)"Filter Selection"));
        this.addEntry(new FilterEntry(this, (Component)Component.translatable((String)"filter.selfiecam.normal"), null));
        for (ResourceLocation shader : ModShaders.SHADERS) {
            this.addEntry(new FilterEntry(this, (Component)Component.translatable((String)("filter.selfiecam." + shader.getPath())), shader));
        }
    }

    public void show() {
        this.visible = true;
        this.active = true;
    }

    public void hide() {
        this.visible = false;
        this.active = false;
    }

    private void addEntry(FilterEntry filterEntry) {
        this.entries.add(filterEntry);
        this.updateEntriesPosition();
    }

    protected int contentHeight() {
        return this.entries.stream().mapToInt(AbstractWidget::getHeight).sum();
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean bl) {
        return super.mouseClicked(mouseButtonEvent, bl);
    }

    protected double scrollRate() {
        return 10.0;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderScrollbar(guiGraphics, i, j);
        guiGraphics.enableScissor(this.getX(), this.getY(), this.getRight(), this.getBottom());
        this.entries.forEach(entry -> {
            if (entry.getY() + entry.getHeight() >= this.getY() && entry.getY() <= this.getBottom()) {
                entry.render(guiGraphics, i, j, f);
            }
        });
        guiGraphics.disableScissor();
    }

    private int getContentWidth() {
        return this.getWidth() - 6;
    }

    public void setScrollAmount(double d) {
        super.setScrollAmount(d);
        this.updateEntriesPosition();
    }

    private void updateEntriesPosition() {
        int i = this.getY() - (int)this.scrollAmount();
        for (FilterEntry entry : this.entries) {
            entry.setY(i);
            i += entry.getHeight();
            entry.setX(this.getX());
            entry.setWidth(this.getContentWidth());
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        return this.entries;
    }

    class FilterEntry
    extends Button {
        private final ResourceLocation shader;

        protected FilterEntry(FilterSelectionWidget this$0, Component message, ResourceLocation shader) {
            super(0, 0, this$0.getContentWidth(), 20, message, button -> {}, Supplier::get);
            this.shader = shader;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
            Minecraft minecraft = Minecraft.getInstance();
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SelfiecamClient.idOf("widget/filter/" + (this.shader == null ? "normal" : this.shader.getPath())), this.getX(), this.getY(), this.getWidth(), this.getHeight(), ARGB.white((float)this.alpha));
            if (this.isHoveredOrFocused()) {
                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SelfiecamClient.idOf("widget/filter_button_highlight"), this.getX(), this.getY(), this.getWidth(), this.getHeight(), ARGB.white((float)this.alpha));
            }
            int k = ARGB.color((float)this.alpha, (int)(this.active ? -1 : -6250336));
            this.renderString(guiGraphics, minecraft.font, k);
            if (this.isHovered()) {
                guiGraphics.requestCursor(this.isActive() ? CursorTypes.POINTING_HAND : CursorTypes.NOT_ALLOWED);
            }
        }

        public void onPress(InputWithModifiers inputWithModifiers) {
            if (this.shader == null) {
                Minecraft.getInstance().gameRenderer.clearPostEffect();
                return;
            }
            Minecraft.getInstance().gameRenderer.setPostEffect(this.shader);
        }
    }
}

