/*
 * Decompiled with CFR 0.152.
 */
package me.imbanana.selfiecam.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.platform.cursor.CursorType;
import com.mojang.blaze3d.platform.cursor.CursorTypes;
import java.util.Objects;
import me.imbanana.selfiecam.SelfiecamClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;

public class RatioSelectionWidget
extends AbstractWidget {
    private int screenWidth;
    private int screenHeight;
    private ResizeMode resizeMode = ResizeMode.NONE;

    public RatioSelectionWidget(int width, int height, int screenWidth, int screenHeight) {
        super(0, 0, width, height, (Component)Component.translatable((String)"gui.selfiecam.camera.select_ratio"));
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.reposition(screenWidth, screenHeight);
    }

    private void reposition(int screenWidth, int screenHeight) {
        this.setX((screenWidth - this.width) / 2);
        this.setY((screenHeight - this.height) / 2);
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    public void resize(int width, int height) {
        this.setWidth(Math.clamp((long)width, 100, this.screenWidth));
        this.setHeight(Math.clamp((long)height, 100, this.screenHeight));
        this.reposition(this.screenWidth, this.screenHeight);
    }

    public int getFrameBufferWidth() {
        return this.getFrameBufferWidth(this.getWidth());
    }

    public int getFrameBufferHeight() {
        return this.getFrameBufferHeight(this.getHeight());
    }

    private int getFrameBufferWidth(int width) {
        Window window = Minecraft.getInstance().getWindow();
        return (int)Math.ceil((float)width / (float)window.getGuiScaledWidth() * (float)window.getWidth());
    }

    public int getFrameBufferHeight(int height) {
        Window window = Minecraft.getInstance().getWindow();
        return (int)Math.ceil((float)height / (float)window.getGuiScaledHeight() * (float)window.getHeight());
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        ResizeMode availableResizeMode;
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SelfiecamClient.idOf("widget/ratio_selection"), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        int backgroundColor = ARGB.color((int)127, (int)0, (int)0, (int)0);
        guiGraphics.fill(0, 0, guiGraphics.guiWidth(), this.getY(), backgroundColor);
        guiGraphics.fill(0, this.getBottom(), guiGraphics.guiWidth(), guiGraphics.guiHeight(), backgroundColor);
        guiGraphics.fill(0, this.getY(), this.getX(), this.getBottom(), backgroundColor);
        guiGraphics.fill(this.getRight(), this.getY(), guiGraphics.guiWidth(), this.getBottom(), backgroundColor);
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().rotateAbout(1.5707964f, (float)this.getX(), (float)this.getY());
        String heightText = String.valueOf(this.getFrameBufferHeight());
        int heightTextX = this.getX() + (this.height - minecraft.font.width(heightText)) / 2;
        int n = this.getY();
        Objects.requireNonNull(minecraft.font);
        int heightTextY = n - 9 - 2;
        guiGraphics.drawString(minecraft.font, heightText, heightTextX, heightTextY, -1);
        guiGraphics.pose().popMatrix();
        String widthText = String.valueOf(this.getFrameBufferWidth());
        int widthTextX = this.getX() + (this.width - minecraft.font.width(heightText)) / 2;
        int widthTextY = this.getY() + 3;
        guiGraphics.drawString(minecraft.font, widthText, widthTextX, widthTextY, -1);
        ResizeMode resizeMode = availableResizeMode = this.resizeMode == ResizeMode.NONE ? this.getAvailableMode(i, j) : this.resizeMode;
        if (availableResizeMode == ResizeMode.HORIZONTAL) {
            guiGraphics.requestCursor(CursorTypes.RESIZE_EW);
        } else if (availableResizeMode == ResizeMode.VERTICAL) {
            guiGraphics.requestCursor(CursorTypes.RESIZE_NS);
        } else if (availableResizeMode == ResizeMode.NORTH_WEST) {
            guiGraphics.requestCursor(CursorType.createStandardCursor((int)221191, (String)"resize_nwse", (CursorType)CursorType.DEFAULT));
        } else if (availableResizeMode == ResizeMode.NORTH_EAST) {
            guiGraphics.requestCursor(CursorType.createStandardCursor((int)221192, (String)"resize_nesw", (CursorType)CursorType.DEFAULT));
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    private ResizeMode getAvailableMode(double mouseX, double mouseY) {
        boolean isInBottomRight;
        double range = 5.0;
        boolean isMouseInLeftSide = this.areCoordinatesInRectangle(mouseX, mouseY, (double)this.getX() - range, (double)this.getY() - range, (double)this.getX() + range, (double)this.getBottom() + range);
        boolean isMouseInRightSide = this.areCoordinatesInRectangle(mouseX, mouseY, (double)this.getRight() - range, (double)this.getY() - range, (double)this.getRight() + range, (double)this.getBottom() + range);
        boolean isMouseInTopSide = this.areCoordinatesInRectangle(mouseX, mouseY, (double)this.getX() - range, (double)this.getY() - range, (double)this.getRight() + range, (double)this.getY() + range);
        boolean isMouseInBottomSide = this.areCoordinatesInRectangle(mouseX, mouseY, (double)this.getX() - range, (double)this.getBottom() - range, (double)this.getRight() + range, (double)this.getBottom() + range);
        boolean isInTopLeft = isMouseInTopSide && isMouseInLeftSide;
        boolean isInTopRight = isMouseInTopSide && isMouseInRightSide;
        boolean isInBottomLeft = isMouseInBottomSide && isMouseInLeftSide;
        boolean bl = isInBottomRight = isMouseInBottomSide && isMouseInRightSide;
        if (isInTopLeft || isInBottomRight) {
            return ResizeMode.NORTH_WEST;
        }
        if (isInTopRight || isInBottomLeft) {
            return ResizeMode.NORTH_EAST;
        }
        if (isMouseInLeftSide || isMouseInRightSide) {
            return ResizeMode.HORIZONTAL;
        }
        if (isMouseInTopSide || isMouseInBottomSide) {
            return ResizeMode.VERTICAL;
        }
        return ResizeMode.NONE;
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean bl) {
        if (!this.isActive()) {
            return false;
        }
        this.resizeMode = this.getAvailableMode(mouseButtonEvent.x(), mouseButtonEvent.y());
        if (this.resizeMode != ResizeMode.NONE) {
            this.onClick(mouseButtonEvent, bl);
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        return false;
    }

    public void onRelease(MouseButtonEvent mouseButtonEvent) {
        this.resizeMode = ResizeMode.NONE;
    }

    protected void onDrag(MouseButtonEvent mouseButtonEvent, double d, double e) {
        boolean horizontal = this.resizeMode == ResizeMode.HORIZONTAL || this.resizeMode == ResizeMode.NORTH_EAST || this.resizeMode == ResizeMode.NORTH_WEST;
        boolean vertical = this.resizeMode == ResizeMode.VERTICAL || this.resizeMode == ResizeMode.NORTH_EAST || this.resizeMode == ResizeMode.NORTH_WEST;
        this.resizeFromMouse((int)mouseButtonEvent.x(), (int)mouseButtonEvent.y(), horizontal, vertical);
    }

    private void resizeFromMouse(int x, int y, boolean horizontal, boolean vertical) {
        this.resize(horizontal ? Math.abs(x - this.screenWidth / 2) * 2 : this.width, vertical ? Math.abs(y - this.screenHeight / 2) * 2 : this.height);
    }

    private boolean areCoordinatesInRectangle(double x, double y, double rectX, double rectY, double rectEndX, double rectEndY) {
        return x >= rectX && y >= rectY && x < rectEndX && y < rectEndY;
    }

    private static enum ResizeMode {
        NORTH_WEST,
        NORTH_EAST,
        HORIZONTAL,
        VERTICAL,
        NONE;

    }
}

