/*
 * Decompiled with CFR 0.152.
 */
package me.imbanana.selfiecam.mixin;

import me.imbanana.selfiecam.SelfiecamClient;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public abstract class GuiMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @Shadow
    protected abstract void renderChat(GuiGraphics var1, DeltaTracker var2);

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkSelfieMode(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        if (this.minecraft.screen instanceof LevelLoadingScreen) {
            return;
        }
        if (SelfiecamClient.getCameraController().shouldHideGUI()) {
            ci.cancel();
            return;
        }
        if (SelfiecamClient.getCameraControlsGui().isEnabled()) {
            SelfiecamClient.getCameraControlsGui().render(guiGraphics, deltaTracker);
        }
        if (SelfiecamClient.getCameraController().isInSelfieMode()) {
            ci.cancel();
            if (!this.minecraft.options.hideGui) {
                this.renderChat(guiGraphics, deltaTracker);
            }
        }
    }
}

