/*
 * Decompiled with CFR 0.152.
 */
package archives.tater.tooltrims;

import archives.tater.tooltrims.ToolTrims;
import archives.tater.tooltrims.ToolTrimsGamerules;
import archives.tater.tooltrims.ToolTrimsPatterns;
import archives.tater.tooltrims.ToolTrimsTags;
import archives.tater.tooltrims.item.ToolTrimsItems;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8055;
import net.minecraft.class_8056;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ToolTrimsDPCompat {
    public static final List<class_5321<class_8054>> legacyMaterialOrder = List.of(class_8055.field_42013, class_8055.field_42008, class_8055.field_42011, class_8055.field_42010, class_8055.field_42009, class_8055.field_42005, class_8055.field_42012, class_8055.field_42006, class_8055.field_42004, class_8055.field_42007);
    public static final List<class_5321<class_8056>> legacyPatternOrder = List.of(ToolTrimsPatterns.LINEAR, ToolTrimsPatterns.TRACKS, ToolTrimsPatterns.CHARGE, ToolTrimsPatterns.FROST);
    private static final String disableGamerule = "/gamerule " + ToolTrimsGamerules.DELETE_TOOLSMITHING_TABLES.method_20771() + " false";
    private static boolean gameruleWasEnabled = false;

    public static void register() {
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)ToolTrims.id("legacy"), (ModContainer)((ModContainer)FabricLoader.getInstance().getModContainer("tooltrims").get()), (class_2561)class_2561.method_43470((String)"Tool Trims Legacy"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        gameruleWasEnabled = false;
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            State state = State.ofServer(server);
            if (!state.hasCheckedForDP()) {
                if (ToolTrimsDPCompat.wasDatapackUsed(server)) {
                    ((class_1928.class_4310)server.method_3767().method_20746(ToolTrimsGamerules.DELETE_TOOLSMITHING_TABLES)).method_20758(true, server);
                    gameruleWasEnabled = true;
                    ToolTrims.LOGGER.warn(class_2561.method_43469((String)"tooltrims.warning.auto_enable", (Object[])new Object[]{disableGamerule}).getString());
                }
                state.setCheckedForDP();
            }
            if (ToolTrimsDPCompat.isDatapackRunning(server)) {
                ToolTrims.LOGGER.warn(class_2561.method_43471((String)"tooltrims.warning.datapack_running").getString());
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (server.method_19466(handler.field_14140.method_7334())) {
                if (gameruleWasEnabled) {
                    handler.field_14140.method_43496((class_2561)class_2561.method_43469((String)"tooltrims.warning.auto_enable", (Object[])new Object[]{disableGamerule}));
                }
                if (ToolTrimsDPCompat.isDatapackRunning(server)) {
                    handler.field_14140.method_43496((class_2561)class_2561.method_43471((String)"tooltrims.warning.datapack_running").method_27692(class_124.field_1065));
                }
            }
        });
    }

    public static boolean wasDatapackUsed(MinecraftServer server) {
        return server.method_3845().method_1163().contains("310_recipe");
    }

    public static boolean isDatapackRunning(MinecraftServer server) {
        return server.method_3740().method_29462(new class_2960("load")).stream().anyMatch(function -> function.comp_1994().equals((Object)new class_2960("tooltrims", "load")));
    }

    public static boolean shouldDeleteToolsmithingTable(class_1531 armorStand) {
        return armorStand.method_37908().method_8450().method_8355(ToolTrimsGamerules.DELETE_TOOLSMITHING_TABLES) && (armorStand.method_5752().contains("310_toolsmithing_table") || armorStand.method_5752().contains("310_place_toolsmithing_table")) && armorStand.method_37908().method_18460((class_1297)armorStand, 6.0) != null;
    }

    public static void deleteToolsmithingTable(class_1531 armorStand) {
        if (armorStand.method_5752().contains("310_toolsmithing_table") && armorStand.method_37908().method_8320(armorStand.method_24515()).method_27852(class_2246.field_16328)) {
            armorStand.method_37908().method_22352(armorStand.method_24515(), false);
        }
        armorStand.method_5775(new class_1799((class_1935)class_1802.field_8118, 4));
        armorStand.method_5775(new class_1799((class_1935)class_1802.field_27022, 2));
        armorStand.method_31472();
    }

    public static int getCustomModelData(class_1799 itemStack, int defaultValue) {
        class_2487 nbt = itemStack.method_7969();
        if (nbt == null) {
            return defaultValue;
        }
        return nbt.method_10550("CustomModelData");
    }

    public static int getCustomModelData(class_5321<class_8054> material, class_5321<class_8056> pattern) {
        return 311001 + legacyPatternOrder.indexOf(pattern) * legacyMaterialOrder.size() + legacyMaterialOrder.indexOf(material);
    }

    public static class_8053 getTrim(class_7871.class_7872 registryLookup, int customModelData) {
        int value = customModelData - 311001;
        class_5321<class_8056> pattern = legacyPatternOrder.get(value / legacyMaterialOrder.size());
        class_5321<class_8054> material = legacyMaterialOrder.get(value % legacyMaterialOrder.size());
        return new class_8053((class_6880)registryLookup.method_46751(class_7924.field_42083).method_46747(material), (class_6880)registryLookup.method_46751(class_7924.field_42082).method_46747(pattern));
    }

    public static class_8053 getTrim(class_1937 world, int customModelData) {
        return ToolTrimsDPCompat.getTrim(world.method_30349().method_46758(), customModelData);
    }

    public static boolean shouldDeleteItem(class_1799 itemStack, @Nullable class_1937 world) {
        if (world != null && !world.method_8450().method_8355(ToolTrimsGamerules.DELETE_TOOLSMITHING_TABLES)) {
            return false;
        }
        if (!itemStack.method_31574(class_1802.field_8238)) {
            return false;
        }
        int customModelData = ToolTrimsDPCompat.getCustomModelData(itemStack, 0);
        return 312001 <= customModelData && customModelData <= 312021;
    }

    @Nullable
    public static class_1799 upgradeItem(class_1937 world, class_1799 itemStack) {
        if (itemStack.method_31574(class_1802.field_8238)) {
            class_1792 item;
            int customModelData = ToolTrimsDPCompat.getCustomModelData(itemStack, 0);
            if (312001 <= customModelData && customModelData <= 312021) {
                return class_1799.field_8037;
            }
            switch (customModelData) {
                case 313001: {
                    class_1792 class_17922 = ToolTrimsItems.LINEAR_TOOL_TRIM_SMITHING_TEMPLATE;
                    break;
                }
                case 313002: {
                    class_1792 class_17922 = ToolTrimsItems.TRACKS_TOOL_TRIM_SMITHING_TEMPLATE;
                    break;
                }
                case 313003: {
                    class_1792 class_17922 = ToolTrimsItems.CHARGE_TOOL_TRIM_SMITHING_TEMPLATE;
                    break;
                }
                case 313004: {
                    class_1792 class_17922 = ToolTrimsItems.FROST_TOOL_TRIM_SMITHING_TEMPLATE;
                    break;
                }
                default: {
                    class_1792 class_17922 = item = null;
                }
            }
            if (item == null) {
                return null;
            }
            return new class_1799((class_1935)item, itemStack.method_7947());
        }
        if (itemStack.method_31573(ToolTrimsTags.TRIMMABLE_TOOLS)) {
            int customModelData = ToolTrimsDPCompat.getCustomModelData(itemStack, 0);
            if (customModelData == 0) {
                return null;
            }
            class_2487 itemNbt = itemStack.method_7948();
            class_2487 display = itemNbt.method_10562("display");
            display.method_10551("Lore");
            if (display.method_10546() == 0) {
                itemNbt.method_10551("display");
            }
            itemNbt.method_10551("trimmed_tool");
            itemNbt.method_10551("combination");
            itemNbt.method_10551("CustomModelData");
            if (class_8053.method_48428((class_5455)world.method_30349(), (class_1799)itemStack, (boolean)true).isEmpty()) {
                class_8053.method_48429((class_5455)world.method_30349(), (class_1799)itemStack, (class_8053)ToolTrimsDPCompat.getTrim(world, customModelData));
            }
            return itemStack;
        }
        return null;
    }

    public static class State
    extends class_18 {
        private static final String CHECKED_NBT = "CheckedForDP";
        private boolean checkedForDP;
        private static final class_18.class_8645<State> TYPE = new class_18.class_8645(State::new, State::fromNbt, null);

        public class_2487 method_75(class_2487 nbt) {
            nbt.method_10556(CHECKED_NBT, this.checkedForDP);
            return nbt;
        }

        public boolean hasCheckedForDP() {
            return this.checkedForDP;
        }

        public void setCheckedForDP() {
            this.checkedForDP = true;
            this.method_78(true);
        }

        public static State fromNbt(class_2487 nbt) {
            State state = new State();
            state.checkedForDP = nbt.method_10577(CHECKED_NBT);
            return state;
        }

        public static State ofServer(MinecraftServer server) {
            return (State)Objects.requireNonNull(server.method_3847(class_1937.field_25179)).method_17983().method_17924(TYPE, "tooltrims");
        }
    }
}

