/*
 * Decompiled with CFR 0.152.
 */
package com.armaninyow.moblocator;

import net.minecraft.class_332;

public class IconRenderer {
    private static final int BLACK = -16777216;
    private static final int GREY_LIGHT = -2039584;
    private static final int GREY_MID = -4408131;

    public static void drawIcon(class_332 context, int centerX, int centerY, int iconType, int baseColor) {
        int color = baseColor | 0xFF000000;
        switch (iconType) {
            case 0: {
                IconRenderer.drawSmallCircle(context, centerX, centerY, color);
                break;
            }
            case 1: {
                IconRenderer.drawSmallSquare(context, centerX, centerY, color);
                break;
            }
            case 2: {
                IconRenderer.drawLargeCircle(context, centerX, centerY, color);
                break;
            }
            case 3: {
                IconRenderer.drawLargeSquare(context, centerX, centerY, color);
            }
        }
    }

    public static void drawArrow(class_332 context, int centerX, int centerY, boolean pointingUp, int baseColor) {
        int color = baseColor | 0xFF000000;
        if (pointingUp) {
            IconRenderer.drawArrowUp(context, centerX, centerY, color);
        } else {
            IconRenderer.drawArrowDown(context, centerX, centerY, color);
        }
    }

    private static void drawSmallCircle(class_332 context, int cx, int cy, int color) {
        int startX = cx - 1;
        int startY = cy - 1;
        int grey = IconRenderer.blendColor(color, -4408131);
        IconRenderer.pixel(context, startX + 0, startY + 0, -16777216);
        IconRenderer.pixel(context, startX + 1, startY + 0, grey);
        IconRenderer.pixel(context, startX + 2, startY + 0, -16777216);
        IconRenderer.pixel(context, startX + 0, startY + 1, grey);
        IconRenderer.pixel(context, startX + 1, startY + 1, color);
        IconRenderer.pixel(context, startX + 2, startY + 1, grey);
        IconRenderer.pixel(context, startX + 0, startY + 2, -16777216);
        IconRenderer.pixel(context, startX + 1, startY + 2, grey);
        IconRenderer.pixel(context, startX + 2, startY + 2, -16777216);
    }

    private static void drawSmallSquare(class_332 context, int cx, int cy, int color) {
        int startX = cx - 2;
        int startY = cy - 2;
        IconRenderer.pixel(context, startX + 1, startY + 0, -16777216);
        IconRenderer.pixel(context, startX + 2, startY + 0, -16777216);
        IconRenderer.pixel(context, startX + 3, startY + 0, -16777216);
        for (int row = 1; row <= 3; ++row) {
            IconRenderer.pixel(context, startX + 0, startY + row, -16777216);
            IconRenderer.pixel(context, startX + 1, startY + row, color);
            IconRenderer.pixel(context, startX + 2, startY + row, color);
            IconRenderer.pixel(context, startX + 3, startY + row, color);
            IconRenderer.pixel(context, startX + 4, startY + row, -16777216);
        }
        IconRenderer.pixel(context, startX + 1, startY + 4, -16777216);
        IconRenderer.pixel(context, startX + 2, startY + 4, -16777216);
        IconRenderer.pixel(context, startX + 3, startY + 4, -16777216);
    }

    private static void drawLargeCircle(class_332 context, int cx, int cy, int color) {
        int startX = cx - 3;
        int startY = cy - 3;
        int grey = IconRenderer.blendColor(color, -4408131);
        IconRenderer.pixel(context, startX + 2, startY + 0, -16777216);
        IconRenderer.pixel(context, startX + 3, startY + 0, -16777216);
        IconRenderer.pixel(context, startX + 4, startY + 0, -16777216);
        IconRenderer.pixel(context, startX + 1, startY + 1, -16777216);
        IconRenderer.pixel(context, startX + 2, startY + 1, grey);
        IconRenderer.pixel(context, startX + 3, startY + 1, grey);
        IconRenderer.pixel(context, startX + 4, startY + 1, grey);
        IconRenderer.pixel(context, startX + 5, startY + 1, -16777216);
        for (int row = 2; row <= 4; ++row) {
            IconRenderer.pixel(context, startX + 0, startY + row, -16777216);
            IconRenderer.pixel(context, startX + 1, startY + row, grey);
            IconRenderer.pixel(context, startX + 2, startY + row, color);
            IconRenderer.pixel(context, startX + 3, startY + row, color);
            IconRenderer.pixel(context, startX + 4, startY + row, color);
            IconRenderer.pixel(context, startX + 5, startY + row, grey);
            IconRenderer.pixel(context, startX + 6, startY + row, -16777216);
        }
        IconRenderer.pixel(context, startX + 1, startY + 5, -16777216);
        IconRenderer.pixel(context, startX + 2, startY + 5, grey);
        IconRenderer.pixel(context, startX + 3, startY + 5, grey);
        IconRenderer.pixel(context, startX + 4, startY + 5, grey);
        IconRenderer.pixel(context, startX + 5, startY + 5, -16777216);
        IconRenderer.pixel(context, startX + 2, startY + 6, -16777216);
        IconRenderer.pixel(context, startX + 3, startY + 6, -16777216);
        IconRenderer.pixel(context, startX + 4, startY + 6, -16777216);
    }

    private static void drawLargeSquare(class_332 context, int cx, int cy, int color) {
        int startX = cx - 3;
        int startY = cy - 3;
        int greyLight = IconRenderer.blendColor(color, -2039584);
        int greyMid = IconRenderer.blendColor(color, -4408131);
        IconRenderer.pixel(context, startX + 1, startY + 0, -16777216);
        IconRenderer.pixel(context, startX + 2, startY + 0, -16777216);
        IconRenderer.pixel(context, startX + 3, startY + 0, -16777216);
        IconRenderer.pixel(context, startX + 4, startY + 0, -16777216);
        IconRenderer.pixel(context, startX + 5, startY + 0, -16777216);
        IconRenderer.pixel(context, startX + 0, startY + 1, -16777216);
        IconRenderer.pixel(context, startX + 1, startY + 1, greyMid);
        IconRenderer.pixel(context, startX + 2, startY + 1, greyLight);
        IconRenderer.pixel(context, startX + 3, startY + 1, greyLight);
        IconRenderer.pixel(context, startX + 4, startY + 1, greyLight);
        IconRenderer.pixel(context, startX + 5, startY + 1, greyMid);
        IconRenderer.pixel(context, startX + 6, startY + 1, -16777216);
        for (int row = 2; row <= 4; ++row) {
            IconRenderer.pixel(context, startX + 0, startY + row, -16777216);
            IconRenderer.pixel(context, startX + 1, startY + row, greyLight);
            IconRenderer.pixel(context, startX + 2, startY + row, color);
            IconRenderer.pixel(context, startX + 3, startY + row, color);
            IconRenderer.pixel(context, startX + 4, startY + row, color);
            IconRenderer.pixel(context, startX + 5, startY + row, greyLight);
            IconRenderer.pixel(context, startX + 6, startY + row, -16777216);
        }
        IconRenderer.pixel(context, startX + 0, startY + 5, -16777216);
        IconRenderer.pixel(context, startX + 1, startY + 5, greyMid);
        IconRenderer.pixel(context, startX + 2, startY + 5, greyLight);
        IconRenderer.pixel(context, startX + 3, startY + 5, greyLight);
        IconRenderer.pixel(context, startX + 4, startY + 5, greyLight);
        IconRenderer.pixel(context, startX + 5, startY + 5, greyMid);
        IconRenderer.pixel(context, startX + 6, startY + 5, -16777216);
        IconRenderer.pixel(context, startX + 1, startY + 6, -16777216);
        IconRenderer.pixel(context, startX + 2, startY + 6, -16777216);
        IconRenderer.pixel(context, startX + 3, startY + 6, -16777216);
        IconRenderer.pixel(context, startX + 4, startY + 6, -16777216);
        IconRenderer.pixel(context, startX + 5, startY + 6, -16777216);
    }

    private static void drawArrowUp(class_332 context, int cx, int cy, int color) {
        int startX = cx - 3;
        int startY = cy - 2;
        IconRenderer.pixel(context, startX + 2, startY + 0, -16777216);
        IconRenderer.pixel(context, startX + 3, startY + 0, -16777216);
        IconRenderer.pixel(context, startX + 4, startY + 0, -16777216);
        IconRenderer.pixel(context, startX + 1, startY + 1, -16777216);
        IconRenderer.pixel(context, startX + 2, startY + 1, color);
        IconRenderer.pixel(context, startX + 3, startY + 1, color);
        IconRenderer.pixel(context, startX + 4, startY + 1, color);
        IconRenderer.pixel(context, startX + 5, startY + 1, -16777216);
        IconRenderer.pixel(context, startX + 0, startY + 2, -16777216);
        IconRenderer.pixel(context, startX + 1, startY + 2, color);
        IconRenderer.pixel(context, startX + 2, startY + 2, color);
        IconRenderer.pixel(context, startX + 3, startY + 2, color);
        IconRenderer.pixel(context, startX + 4, startY + 2, color);
        IconRenderer.pixel(context, startX + 5, startY + 2, color);
        IconRenderer.pixel(context, startX + 6, startY + 2, -16777216);
        for (int x = 0; x <= 6; ++x) {
            IconRenderer.pixel(context, startX + x, startY + 3, -16777216);
        }
    }

    private static void drawArrowDown(class_332 context, int cx, int cy, int color) {
        int startX = cx - 3;
        int startY = cy - 2;
        for (int x = 0; x <= 6; ++x) {
            IconRenderer.pixel(context, startX + x, startY + 0, -16777216);
        }
        IconRenderer.pixel(context, startX + 0, startY + 1, -16777216);
        IconRenderer.pixel(context, startX + 1, startY + 1, color);
        IconRenderer.pixel(context, startX + 2, startY + 1, color);
        IconRenderer.pixel(context, startX + 3, startY + 1, color);
        IconRenderer.pixel(context, startX + 4, startY + 1, color);
        IconRenderer.pixel(context, startX + 5, startY + 1, color);
        IconRenderer.pixel(context, startX + 6, startY + 1, -16777216);
        IconRenderer.pixel(context, startX + 1, startY + 2, -16777216);
        IconRenderer.pixel(context, startX + 2, startY + 2, color);
        IconRenderer.pixel(context, startX + 3, startY + 2, color);
        IconRenderer.pixel(context, startX + 4, startY + 2, color);
        IconRenderer.pixel(context, startX + 5, startY + 2, -16777216);
        IconRenderer.pixel(context, startX + 2, startY + 3, -16777216);
        IconRenderer.pixel(context, startX + 3, startY + 3, -16777216);
        IconRenderer.pixel(context, startX + 4, startY + 3, -16777216);
    }

    private static void pixel(class_332 context, int x, int y, int color) {
        context.method_25294(x, y, x + 1, y + 1, color);
    }

    private static int blendColor(int color, int grey) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int greyValue = grey & 0xFF;
        float factor = (float)greyValue / 255.0f;
        int newR = (int)((float)r * factor);
        int newG = (int)((float)g * factor);
        int newB = (int)((float)b * factor);
        return 0xFF000000 | newR << 16 | newG << 8 | newB;
    }
}

