/*
 * Decompiled with CFR 0.152.
 */
package com.armaninyow.moblocator;

import com.armaninyow.moblocator.MobLocatorMod;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class MobLocatorConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "moblocator.json");
    public static boolean showInvisibleMobs = false;
    public static int hostileMobColor = 0xFF0000;
    public static int passiveMobColor = 0xFFFFFF;
    public static int invisibleMobColor = 0x808080;

    public static void load() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                ConfigData data = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
                if (data != null) {
                    showInvisibleMobs = data.showInvisibleMobs;
                    hostileMobColor = data.hostileMobColor & 0xFFFFFF;
                    passiveMobColor = data.passiveMobColor & 0xFFFFFF;
                    invisibleMobColor = data.invisibleMobColor & 0xFFFFFF;
                }
            }
            catch (IOException e) {
                MobLocatorMod.LOGGER.error("Failed to load config", (Throwable)e);
            }
        }
        MobLocatorConfig.save();
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            ConfigData data = new ConfigData();
            data.showInvisibleMobs = showInvisibleMobs;
            data.hostileMobColor = hostileMobColor & 0xFFFFFF;
            data.passiveMobColor = passiveMobColor & 0xFFFFFF;
            data.invisibleMobColor = invisibleMobColor & 0xFFFFFF;
            GSON.toJson((Object)data, (Appendable)writer);
        }
        catch (IOException e) {
            MobLocatorMod.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    private static class ConfigData {
        boolean showInvisibleMobs = false;
        int hostileMobColor = 0xFF0000;
        int passiveMobColor = 0xFFFFFF;
        int invisibleMobColor = 0x808080;

        private ConfigData() {
        }
    }
}

