/*
 * Decompiled with CFR 0.152.
 */
package com.armaninyow.moblocator;

import com.armaninyow.moblocator.IconRenderer;
import com.armaninyow.moblocator.MobLocatorConfig;
import java.util.ArrayList;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1439;
import net.minecraft.class_1456;
import net.minecraft.class_1493;
import net.minecraft.class_1510;
import net.minecraft.class_1545;
import net.minecraft.class_1549;
import net.minecraft.class_1551;
import net.minecraft.class_1560;
import net.minecraft.class_1571;
import net.minecraft.class_1588;
import net.minecraft.class_1589;
import net.minecraft.class_1590;
import net.minecraft.class_1593;
import net.minecraft.class_1606;
import net.minecraft.class_1621;
import net.minecraft.class_1628;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4466;
import net.minecraft.class_4836;
import net.minecraft.class_7260;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobLocatorMod
implements ClientModInitializer {
    public static final String MOD_ID = "moblocator";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"moblocator");

    public void onInitializeClient() {
        LOGGER.info("MobLocator - Pixel-perfect icons with color configuration!");
        MobLocatorConfig.load();
        HudRenderCallback.EVENT.register(this::renderMobLocator);
    }

    private void renderMobLocator(class_332 context, class_9779 tickCounter) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        class_746 player = client.field_1724;
        int screenWidth = context.method_51421();
        int screenHeight = context.method_51443();
        int xpBarWidth = 182;
        int centerX = screenWidth / 2;
        int xpBarLeft = centerX - xpBarWidth / 2;
        int baseY = screenHeight - 27;
        ArrayList<MobInfo> detectedMobs = new ArrayList<MobInfo>();
        for (class_1309 entity : client.field_1687.method_8390(class_1309.class, player.method_5829().method_1014(64.0), arg_0 -> MobLocatorMod.lambda$renderMobLocator$0((class_1657)player, arg_0))) {
            float hearingRange;
            double distance;
            if (entity.method_5767() && !MobLocatorConfig.showInvisibleMobs || !((distance = (double)player.method_5739((class_1297)entity)) <= (double)(hearingRange = this.getHearingRange(entity)))) continue;
            boolean isHostile = this.isHostileMob(entity) || this.isAngryNeutralMob(entity);
            int iconType = this.getIconType(distance, hearingRange);
            int color = entity.method_5767() ? MobLocatorConfig.invisibleMobColor : (isHostile ? MobLocatorConfig.hostileMobColor : MobLocatorConfig.passiveMobColor);
            double dy = entity.method_23318() - player.method_23318();
            boolean isAbove = dy > 3.0;
            boolean isBelow = dy < -3.0;
            detectedMobs.add(new MobInfo(entity, (class_1657)player, iconType, color, isAbove, isBelow));
        }
        for (MobInfo mobInfo : detectedMobs) {
            this.renderMobIndicator(context, mobInfo, xpBarLeft, xpBarWidth, baseY);
        }
    }

    private void renderMobIndicator(class_332 context, MobInfo mobInfo, int xpBarLeft, int xpBarWidth, int baseY) {
        double angle = mobInfo.angle;
        double clampedAngle = Math.max(-1.5707963267948966, Math.min(1.5707963267948966, angle));
        double normalizedPos = 0.5 - clampedAngle / Math.PI;
        int x = xpBarLeft + (int)(normalizedPos * (double)xpBarWidth);
        int y = baseY;
        if (mobInfo.isAbove) {
            IconRenderer.drawArrow(context, x, y - 6, true, mobInfo.color);
        } else if (mobInfo.isBelow) {
            IconRenderer.drawArrow(context, x, y + 6, false, mobInfo.color);
        }
        IconRenderer.drawIcon(context, x, y, mobInfo.iconType, mobInfo.color);
    }

    private float getHearingRange(class_1309 entity) {
        String entityName = entity.getClass().getSimpleName();
        if (entity instanceof class_1510) {
            return 192.0f;
        }
        if (entity instanceof class_1593) {
            return 36.0f;
        }
        if (entity instanceof class_7260) {
            return 48.0f;
        }
        if (entity instanceof class_1571) {
            return 64.0f;
        }
        if (entity instanceof class_1545) {
            return 48.0f;
        }
        if (entityName.contains("Wither")) {
            return 40.0f;
        }
        if (entity instanceof class_1560) {
            return 64.0f;
        }
        if (entity instanceof class_1551) {
            return 32.0f;
        }
        if (entityName.equals("AllayEntity")) {
            return 64.0f;
        }
        if (entityName.equals("BatEntity")) {
            return 8.0f;
        }
        return 16.0f;
    }

    private int getIconType(double distance, float hearingRange) {
        double ratio = distance / (double)hearingRange;
        if (ratio <= 0.25) {
            return 3;
        }
        if (ratio <= 0.5) {
            return 2;
        }
        if (ratio <= 0.75) {
            return 1;
        }
        return 0;
    }

    private boolean isHostileMob(class_1309 entity) {
        return entity instanceof class_1588 || entity instanceof class_1621 || entity instanceof class_1593 || entity instanceof class_1589 || entity instanceof class_1606;
    }

    private boolean isAngryNeutralMob(class_1309 entity) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return false;
        }
        if (entity instanceof class_1560) {
            class_1560 enderman = (class_1560)entity;
            return enderman.method_7028();
        }
        if (entity instanceof class_4836) {
            class_4836 piglin = (class_4836)entity;
            return piglin.method_5968() == client.field_1724;
        }
        if (entity instanceof class_1590) {
            class_1590 zombifiedPiglin = (class_1590)entity;
            return zombifiedPiglin.method_5968() == client.field_1724;
        }
        if (entity instanceof class_1493) {
            class_1493 wolf = (class_1493)entity;
            return wolf.method_6510();
        }
        if (entity instanceof class_1456) {
            class_1456 bear = (class_1456)entity;
            return bear.method_6510();
        }
        if (entity instanceof class_1628) {
            class_1628 spider = (class_1628)entity;
            return spider.method_6510();
        }
        if (entity instanceof class_1549) {
            class_1549 caveSpider = (class_1549)entity;
            return caveSpider.method_6510();
        }
        if (entity instanceof class_1439) {
            class_1439 golem = (class_1439)entity;
            return golem.method_6510();
        }
        if (entity instanceof class_4466) {
            class_4466 bee = (class_4466)entity;
            return bee.method_29511();
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$renderMobLocator$0(class_1657 player, class_1309 e) {
        return e != player && e.method_5805();
    }

    private static class MobInfo {
        double angle;
        int iconType;
        int color;
        boolean isAbove;
        boolean isBelow;
        float playerYaw;

        MobInfo(class_1309 mob, class_1657 player, int iconType, int color, boolean isAbove, boolean isBelow) {
            this.iconType = iconType;
            this.color = color;
            this.isAbove = isAbove;
            this.isBelow = isBelow;
            this.playerYaw = player.method_36454();
            double dx = mob.method_23317() - player.method_23317();
            double dz = mob.method_23321() - player.method_23321();
            double angleToMob = Math.atan2(dx, dz);
            double playerYawRad = Math.toRadians(-player.method_36454());
            this.angle = angleToMob - playerYawRad;
            while (this.angle > Math.PI) {
                this.angle -= Math.PI * 2;
            }
            while (this.angle < -Math.PI) {
                this.angle += Math.PI * 2;
            }
        }
    }
}

