/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.chesed_boss.chesed_crystal;

import com.finderfeed.fdbosses.content.entities.chesed_boss.ChesedBossBuddy;
import com.finderfeed.fdbosses.init.BossAnims;
import com.finderfeed.fdbosses.init.BossEffects;
import com.finderfeed.fdbosses.init.BossSounds;
import com.finderfeed.fdlib.init.FDEDataSerializers;
import com.finderfeed.fdlib.systems.bedrock.animations.Animation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.FDLivingEntity;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ChesedCrystalEntity
extends FDLivingEntity
implements ChesedBossBuddy {
    public static final EntityDataAccessor<Vec3> DIRECTION = SynchedEntityData.defineId(ChesedCrystalEntity.class, (EntityDataSerializer)((EntityDataSerializer)FDEDataSerializers.VEC3.get()));
    private boolean dead = false;
    private int deathTime = 20;

    public ChesedCrystalEntity(EntityType<? extends FDLivingEntity> type, Level level) {
        super(type, level);
        this.getAnimationSystem().startAnimation("SPAWN", AnimationTicker.builder((Animation)((Animation)BossAnims.CHESED_CRYSTAL_SPAWN.get())).setToNullTransitionTime(0).build());
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.dead && this.deathTime-- < 0) {
            this.setRemoved(Entity.RemovalReason.KILLED);
            this.gameEvent((Holder)GameEvent.ENTITY_DIE);
        }
    }

    public void die(DamageSource src) {
        if (!this.level().isClientSide) {
            if (this.lastHurtByPlayer != null) {
                this.lastHurtByPlayer.addEffect(new MobEffectInstance(BossEffects.CHESED_ENERGIZED, 400, 1, false, true));
            }
            this.dead = true;
            this.deathTime = 10;
            this.getAnimationSystem().startAnimation("DEATH", AnimationTicker.builder((Animation)((Animation)BossAnims.CHESED_CRYSTAL_SPAWN.get())).setLoopMode(Animation.LoopMode.HOLD_ON_LAST_FRAME).reversed().setSpeed(2.0f).build());
        }
    }

    public boolean hurt(DamageSource src, float amount) {
        Entity entity = src.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.setLastHurtByPlayer(player);
            float modifier = 1.0f;
            Item item = player.getMainHandItem().getItem();
            if (item instanceof AxeItem) {
                AxeItem axe = (AxeItem)item;
            } else {
                modifier = 0.05f;
            }
            return super.hurt(src, amount * modifier);
        }
        if (src.is(DamageTypes.GENERIC_KILL) || src.is(DamageTypes.FELL_OUT_OF_WORLD)) {
            this.lastHurtByPlayer = null;
            return super.hurt(src, amount);
        }
        this.lastHurtByPlayer = null;
        return false;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource src) {
        if (src.is(DamageTypes.GENERIC_KILL)) {
            return null;
        }
        return BossSounds.CHESED_CRYSTAL_HIT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return BossSounds.CHESED_CRYSTAL_HIT.get();
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
    }

    public void onRemovedFromLevel() {
        super.onRemovedFromLevel();
    }

    public boolean isNoGravity() {
        return true;
    }

    protected void applyGravity() {
    }

    public void knockback(double p_147241_, double p_147242_, double p_147243_) {
    }

    public void push(Vec3 p_347665_) {
    }

    public void push(Entity p_21294_) {
    }

    public void push(double p_20286_, double p_20287_, double p_20288_) {
    }

    protected void pushEntities() {
    }

    protected void playHurtSound(DamageSource src) {
        super.playHurtSound(src);
    }

    public Vec3 getCrystalFacingDirection() {
        return (Vec3)this.entityData.get(DIRECTION);
    }

    public void setCrystalFacingDirection(Vec3 v) {
        this.entityData.set(DIRECTION, (Object)v);
    }

    public boolean isPickable() {
        return true;
    }

    public boolean shouldRender(double p_20296_, double p_20297_, double p_20298_) {
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder data) {
        super.defineSynchedData(data);
        data.define(DIRECTION, (Object)new Vec3(0.0, 1.0, 0.0));
    }
}

