/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah.chain_trap;

import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.content.entities.geburah.chain_trap.GeburahChainTrapEntity;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.FDEntity;
import com.finderfeed.fdlib.systems.trails.FDTrailDataGenerator;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class ChainTrapSummonProjectile
extends FDEntity {
    public FDTrailDataGenerator<ChainTrapSummonProjectile> trail = new FDTrailDataGenerator(Entity::getPosition, 3, 0.01f);
    public static final double GRAVITY = 0.08;

    public static ChainTrapSummonProjectile summon(Level level, Vec3 pos, Vec3 targetPos) {
        ChainTrapSummonProjectile projectile = new ChainTrapSummonProjectile(BossEntities.GEBURAH_CHAIN_TRAP_SUMMON_PROJECTILE.get(), level);
        Vec3 velocity = BossUtil.calculateMortarProjectileVelocity(pos, targetPos, -0.08, 20);
        projectile.setPos(pos);
        projectile.setDeltaMovement(velocity);
        level.addFreshEntity((Entity)projectile);
        return projectile;
    }

    public ChainTrapSummonProjectile(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.tickCount > 2000) {
                this.setRemoved(Entity.RemovalReason.DISCARDED);
            }
            this.tickAndSummonTrap();
        } else {
            this.trail.tick((Object)this);
        }
        this.setPos(this.position().add(this.getDeltaMovement()));
        this.applyGravity();
    }

    private void tickAndSummonTrap() {
        ClipContext clipContext = new ClipContext(this.position(), this.position().add(this.getDeltaMovement()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty());
        BlockHitResult result = this.level().clip(clipContext);
        if (result.getType() != HitResult.Type.MISS) {
            Vec3 location = result.getLocation();
            GeburahChainTrapEntity trapEntity = new GeburahChainTrapEntity(BossEntities.GEBURAH_CHAIN_TRAP.get(), this.level());
            float fraction = (float)(location.y - (double)((int)location.y));
            Vec3 pos = location.add(0.0, (double)0.01f, 0.0);
            if ((double)fraction > 0.25) {
                pos = new Vec3(pos.x, Math.ceil(pos.y), pos.z);
            }
            trapEntity.setPos(pos);
            this.level().addFreshEntity((Entity)trapEntity);
            this.setRemoved(Entity.RemovalReason.DISCARDED);
        }
    }

    protected double getDefaultGravity() {
        return 0.08;
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326003_) {
    }

    public boolean isPickable() {
        return true;
    }
}

