/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah.judgement_bird;

import com.finderfeed.fdbosses.content.entities.geburah.GeburahBossBuddy;
import com.finderfeed.fdbosses.content.entities.geburah.casts.GeburahRayCastingCircle;
import com.finderfeed.fdbosses.init.BossAnims;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossModels;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.systems.bedrock.animations.Animation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.FDMob;
import com.finderfeed.fdlib.systems.bedrock.models.FDModel;
import com.finderfeed.fdlib.util.client.particles.FDBlockParticleOptions;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import java.util.Optional;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class JudgementBirdEntity
extends FDMob
implements AutoSerializable,
GeburahBossBuddy {
    private static FDModel MODEL;
    private static float FLY_TO_TARGET_RADIUS;
    private static float ATTACK_RADIUS;
    @SerializableField
    private Vec3 targetPos;
    @SerializableField
    private int castingTicker = -1;
    @SerializableField
    private Vec3 castingTargetPos;
    @SerializableField
    private Vec3 noTargetFlyToPos;
    private AABB roostingBox;

    public static JudgementBirdEntity summon(Level level, Vec3 pos, Vec3 noTargetFlyToPos, AABB roostingBox) {
        JudgementBirdEntity entity = new JudgementBirdEntity(BossEntities.JUDGEMENT_BIRD.get(), level);
        entity.setPos(pos);
        entity.noTargetFlyToPos = noTargetFlyToPos;
        entity.roostingBox = roostingBox;
        level.addFreshEntity((Entity)entity);
        return entity;
    }

    public static JudgementBirdEntity summon(Level level, Vec3 pos, Vec3 noTargetFlyToPos) {
        return JudgementBirdEntity.summon(level, pos, noTargetFlyToPos, null);
    }

    public JudgementBirdEntity(EntityType<? extends Mob> type, Level level) {
        super(type, level);
        if (level.isClientSide && MODEL == null) {
            MODEL = new FDModel(BossModels.JUDGEMENT_BIRD.get());
        }
        this.setNoGravity(true);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(0, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            protected void findTarget() {
                super.findTarget();
                if (this.target != null && !JudgementBirdEntity.this.isTargetInRoostingBox(this.target)) {
                    this.target = null;
                }
            }
        });
    }

    public void tick() {
        if (!this.level().isClientSide && !this.isDeadOrDying()) {
            if (this.getTarget() != null) {
                this.checkTargetInRoostingBox(this.getTarget());
            }
            this.flyAndAttack();
        }
        super.tick();
    }

    private void flyAndAttack() {
        if (this.castingTargetPos == null) {
            this.castingTicker = -1;
        }
        if (this.castingTicker == -1) {
            Animation animation = (Animation)BossAnims.JUDGEMENT_BIRD_FLY.get();
            if (this.getTarget() == null) {
                if (this.roostingBox != null && !this.roostingBox.contains(this.position())) {
                    this.setMoveTargetPos(this.roostingBox.getCenter());
                }
                if (this.targetPos != null) {
                    this.flyToPos(this.targetPos);
                }
            } else {
                LivingEntity target = this.getTarget();
                Vec3 pos = this.getFlyToTargetPos(target);
                this.flyToPos(pos);
                this.lookAt(EntityAnchorArgument.Anchor.FEET, target.position());
                if (this.distanceTo((Entity)target) < ATTACK_RADIUS) {
                    this.castingTicker = ((Animation)BossAnims.JUDGEMENT_BIRD_CAST.get()).getAnimTime();
                    this.castingTargetPos = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
                    this.setDeltaMovement(Vec3.ZERO);
                }
            }
            this.getAnimationSystem().startAnimation("MAIN", AnimationTicker.builder((Animation)animation).build());
        } else {
            LivingEntity target = this.getTarget();
            if (this.castingTicker > 30 && target != null) {
                this.castingTargetPos = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
            }
            this.castingTicker = Mth.clamp((int)(this.castingTicker - 1), (int)0, (int)Integer.MAX_VALUE);
            this.getAnimationSystem().startAnimation("MAIN", AnimationTicker.builder(BossAnims.JUDGEMENT_BIRD_CAST).nextAnimation(AnimationTicker.builder(BossAnims.JUDGEMENT_BIRD_FLY).build()).build());
            this.lookAt(EntityAnchorArgument.Anchor.FEET, this.castingTargetPos);
            if (this.castingTicker == 30) {
                Vec3 startPos = this.position();
                GeburahRayCastingCircle.summon(this.level(), startPos, this.castingTargetPos.subtract(startPos));
            }
            if (this.castingTicker == 0) {
                this.castingTargetPos = null;
                this.castingTicker = -1;
            }
        }
    }

    protected void tickDeath() {
        if (!this.level().isClientSide() && !this.isRemoved()) {
            this.playSound(SoundEvents.STONE_BREAK, 1.0f, 0.5f);
            this.playSound(SoundEvents.DEEPSLATE_BREAK, 1.0f, 0.5f);
            this.playSound(SoundEvents.STEM_BREAK, 1.0f, 0.5f);
            this.remove(Entity.RemovalReason.KILLED);
            BallParticleOptions ballParticleOptions = BallParticleOptions.builder().size(0.25f).scalingOptions(0, 0, 10).color(0.3f, 0.7f, 1.0f).friction(0.7f).build();
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ballParticleOptions, this.getX(), this.getY() + (double)this.getBbHeight(), this.getZ(), 70, (double)0.1f, (double)0.1f, (double)0.1f, (double)0.4f);
            FDBlockParticleOptions blockParticleOptions = FDBlockParticleOptions.builder().lifetime(40).state(Blocks.DEEPSLATE).quadSizeMultiplier(0.75f + this.random.nextFloat() * 0.5f).build();
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)blockParticleOptions, this.getX(), this.getY() + (double)this.getBbHeight(), this.getZ(), 70, (double)0.1f, (double)0.1f, (double)0.1f, (double)0.4f);
        }
    }

    protected void playHurtSound(DamageSource p_21493_) {
        this.playSound(SoundEvents.STONE_BREAK, 1.0f, 0.5f);
        this.playSound(SoundEvents.DEEPSLATE_BREAK, 1.0f, 0.5f);
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return null;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public boolean isNoGravity() {
        return true;
    }

    private boolean isTargetInRoostingBox(LivingEntity target) {
        if (this.roostingBox != null) {
            Vec3 targetPos = this.getFlyToTargetPos(target);
            return new AABB(this.roostingBox.minX, this.roostingBox.minY - (double)FLY_TO_TARGET_RADIUS, this.roostingBox.minZ, this.roostingBox.maxX, this.roostingBox.maxY + (double)FLY_TO_TARGET_RADIUS, this.roostingBox.maxZ).contains(targetPos);
        }
        return true;
    }

    private void checkTargetInRoostingBox(LivingEntity target) {
        if (this.roostingBox != null && !this.isTargetInRoostingBox(target)) {
            this.setMoveTargetPos(this.noTargetFlyToPos);
            this.setTarget(null);
        }
    }

    public void setMoveTargetPos(Vec3 targetPos) {
        Vec3 pos;
        this.targetPos = this.roostingBox == null ? targetPos : (this.roostingBox.contains(targetPos) ? targetPos : ((pos = this.clipRoostingBox(targetPos)) == null ? this.roostingBox.getCenter() : pos));
    }

    private Vec3 clipRoostingBox(Vec3 target) {
        Optional cl = this.roostingBox.clip(target, this.position());
        if (cl.isEmpty()) {
            cl = this.roostingBox.clip(this.position(), target);
            if (cl.isPresent()) {
                return (Vec3)cl.get();
            }
        } else {
            return (Vec3)cl.get();
        }
        return null;
    }

    private Vec3 getFlyToTargetPos(LivingEntity target) {
        Vec3 targetPos = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
        Vec3 b = targetPos.subtract(this.position());
        double dist = b.length();
        Vec3 resultPos = dist > (double)FLY_TO_TARGET_RADIUS ? targetPos : this.position();
        if (this.roostingBox != null) {
            double y = Math.max(this.roostingBox.minY, Math.min(resultPos.y, this.roostingBox.maxY));
            return new Vec3(resultPos.x, y, resultPos.z);
        }
        return resultPos;
    }

    private void flyToPos(Vec3 pos) {
        Vec3 between = pos.subtract(this.position());
        double speed = this.getAttributeValue(Attributes.MOVEMENT_SPEED);
        double b = between.length();
        speed = FDMathUtil.lerp((double)0.0, (double)speed, (double)Mth.clamp((float)FDEasings.easeIn((float)((float)(b / Math.max(3.0, speed)))), (float)0.0f, (float)1.0f));
        Vec3 deltaMovement = between.normalize().scale(speed);
        this.setDeltaMovement(deltaMovement);
        this.lookAt(EntityAnchorArgument.Anchor.FEET, pos);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.autoLoad(tag);
        if (tag.contains("roostingBoxMinX")) {
            this.roostingBox = new AABB(tag.getDouble("roostingBoxMinX"), tag.getDouble("roostingBoxMinY"), tag.getDouble("roostingBoxMinZ"), tag.getDouble("roostingBoxMaxX"), tag.getDouble("roostingBoxMaxY"), tag.getDouble("roostingBoxMaxZ"));
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.autoSave(tag);
        if (this.roostingBox != null) {
            tag.putDouble("roostingBoxMinX", this.roostingBox.minX);
            tag.putDouble("roostingBoxMinY", this.roostingBox.minY);
            tag.putDouble("roostingBoxMinZ", this.roostingBox.minZ);
            tag.putDouble("roostingBoxMaxX", this.roostingBox.maxX);
            tag.putDouble("roostingBoxMaxY", this.roostingBox.maxY);
            tag.putDouble("roostingBoxMaxZ", this.roostingBox.maxZ);
        }
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    static {
        FLY_TO_TARGET_RADIUS = 6.5f;
        ATTACK_RADIUS = 7.0f;
    }
}

