/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.items.chesed;

import com.finderfeed.fdbosses.content.items.chesed.PhaseSphereHandler;
import com.finderfeed.fdbosses.init.BossAnims;
import com.finderfeed.fdlib.systems.bedrock.animations.Animation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.AnimatedItem;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.FDItemAnimationHandler;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.FDItemAnimationSystem;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.FDServerItemAnimations;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.animated_item.AnimatedItemStackContext;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class PhaseSphere
extends Item
implements AnimatedItem {
    public PhaseSphere(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide) {
            if (PhaseSphereHandler.canContinueUsingChesedItem(player)) {
                FDServerItemAnimations.startItemAnimation((LivingEntity)player, (String)"USE", (AnimationTicker)AnimationTicker.builder(BossAnims.CHESED_ITEM_USE).setToNullTransitionTime(0).build(), (InteractionHand)hand);
                player.startUsingItem(hand);
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.RESPAWN_ANCHOR_CHARGE, SoundSource.PLAYERS, 1.0f, 0.9f);
                return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
            }
            return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
        }
        return super.use(level, player, hand);
    }

    public int getUseDuration(ItemStack p_41454_, LivingEntity p_344979_) {
        return 72000;
    }

    public void onUseTick(Level p_41428_, LivingEntity entity, ItemStack p_41430_, int p_41431_) {
        super.onUseTick(p_41428_, entity, p_41430_, p_41431_);
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        super.onStopUsing(stack, entity, count);
        if (!entity.level().isClientSide) {
            entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), (Holder)SoundEvents.RESPAWN_ANCHOR_DEPLETE, SoundSource.PLAYERS, 1.0f, 0.75f);
        }
    }

    public void inventoryTick(ItemStack stack, Level p_41405_, Entity entity, int slot, boolean p_41408_) {
        super.inventoryTick(stack, p_41405_, entity, slot, p_41408_);
    }

    public void animatedItemTick(AnimatedItemStackContext ctx) {
        FDItemAnimationSystem animSystem = FDItemAnimationHandler.getItemAnimationSystem((AnimatedItemStackContext)ctx);
        if (animSystem != null) {
            animSystem.startAnimation("IDLE", AnimationTicker.builder((Animation)((Animation)BossAnims.CHESED_ITEM_IDLE.get())).build());
        }
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_339594_, List<Component> components, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_339594_, components, p_41424_);
        components.add((Component)Component.translatable((String)"fdbosses.word.phase_sphere_description").withStyle(ChatFormatting.AQUA));
    }
}

